/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.util.FastMath;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnDecreasing;

public class LongitudeRangeCrossingDetector
extends AbstractDetector<LongitudeRangeCrossingDetector> {
    private final OneAxisEllipsoid body;
    private final double fromLongitude;
    private final double toLongitude;
    private final double sign;

    public LongitudeRangeCrossingDetector(OneAxisEllipsoid body, double fromLongitude, double toLongitude) {
        this(600.0, 1.0E-6, body, fromLongitude, toLongitude);
    }

    public LongitudeRangeCrossingDetector(double maxCheck, double threshold, OneAxisEllipsoid body, double fromLongitude, double toLongitude) {
        this(AdaptableInterval.of(maxCheck), threshold, 100, new StopOnDecreasing(), body, fromLongitude, toLongitude);
    }

    protected LongitudeRangeCrossingDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, OneAxisEllipsoid body, double fromLongitude, double toLongitude) {
        super(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
        this.body = body;
        this.fromLongitude = this.ensureLongitudePositiveContinuity(fromLongitude);
        this.toLongitude = this.ensureLongitudePositiveContinuity(toLongitude);
        this.sign = FastMath.signum((double)(this.toLongitude - this.fromLongitude));
    }

    @Override
    protected LongitudeRangeCrossingDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new LongitudeRangeCrossingDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.body, this.fromLongitude, this.toLongitude);
    }

    public OneAxisEllipsoid getBody() {
        return this.body;
    }

    public double getFromLongitude() {
        return this.getLongitudeOverOriginalRange(this.fromLongitude);
    }

    public double getToLongitude() {
        return this.getLongitudeOverOriginalRange(this.toLongitude);
    }

    private double ensureLongitudePositiveContinuity(double longitude) {
        return longitude < 0.0 ? longitude + Math.PI * 2 : longitude;
    }

    private double getLongitudeOverOriginalRange(double longitude) {
        return longitude > Math.PI ? longitude - Math.PI * 2 : longitude;
    }

    @Override
    public double g(SpacecraftState s) {
        GeodeticPoint gp = this.body.transform(s.getPVCoordinates().getPosition(), s.getFrame(), s.getDate());
        double longitude = this.ensureLongitudePositiveContinuity(gp.getLongitude());
        return this.sign * (longitude - this.fromLongitude) * (this.toLongitude - longitude);
    }
}

