/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EnablingPredicate;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.EventEnablingPredicateFilter;
import org.orekit.propagation.events.handlers.ContinueOnEvent;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;
import org.orekit.time.AbsoluteDate;

public class LongitudeCrossingDetector
extends AbstractDetector<LongitudeCrossingDetector> {
    private OneAxisEllipsoid body;
    private final double longitude;
    private final EventEnablingPredicateFilter filtering;

    public LongitudeCrossingDetector(OneAxisEllipsoid body, double longitude) {
        this(600.0, 1.0E-6, body, longitude);
    }

    public LongitudeCrossingDetector(double maxCheck, double threshold, OneAxisEllipsoid body, double longitude) {
        this(AdaptableInterval.of(maxCheck), threshold, 100, new StopOnIncreasing(), body, longitude);
    }

    protected LongitudeCrossingDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, OneAxisEllipsoid body, double longitude) {
        super(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
        this.body = body;
        this.longitude = longitude;
        RawLongitudeCrossingDetector raw = new RawLongitudeCrossingDetector(maxCheck, threshold, maxIter, new ContinueOnEvent());
        EnablingPredicate predicate = (state, detector, g) -> FastMath.abs((double)g) < 1.5707963267948966;
        this.filtering = new EventEnablingPredicateFilter(raw, predicate);
    }

    @Override
    protected LongitudeCrossingDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new LongitudeCrossingDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.body, this.longitude);
    }

    public OneAxisEllipsoid getBody() {
        return this.body;
    }

    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        this.filtering.init(s0, t);
    }

    @Override
    public double g(SpacecraftState s) {
        return this.filtering.g(s);
    }

    private class RawLongitudeCrossingDetector
    extends AbstractDetector<RawLongitudeCrossingDetector> {
        protected RawLongitudeCrossingDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler) {
            super(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
        }

        @Override
        protected RawLongitudeCrossingDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
            return new RawLongitudeCrossingDetector(newMaxCheck, newThreshold, newMaxIter, newHandler);
        }

        @Override
        public double g(SpacecraftState s) {
            GeodeticPoint gp = LongitudeCrossingDetector.this.body.transform(s.getPosition(), s.getFrame(), s.getDate());
            return MathUtils.normalizeAngle((double)(gp.getLongitude() - LongitudeCrossingDetector.this.longitude), (double)0.0);
        }
    }
}

