/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.util.FastMath;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnDecreasing;

public class LatitudeRangeCrossingDetector
extends AbstractDetector<LatitudeRangeCrossingDetector> {
    private final OneAxisEllipsoid body;
    private final double fromLatitude;
    private final double toLatitude;
    private final double sign;

    public LatitudeRangeCrossingDetector(OneAxisEllipsoid body, double fromLatitude, double toLatitude) {
        this(600.0, 1.0E-6, body, fromLatitude, toLatitude);
    }

    public LatitudeRangeCrossingDetector(double maxCheck, double threshold, OneAxisEllipsoid body, double fromLatitude, double toLatitude) {
        this(AdaptableInterval.of(maxCheck), threshold, 100, new StopOnDecreasing(), body, fromLatitude, toLatitude);
    }

    protected LatitudeRangeCrossingDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, OneAxisEllipsoid body, double fromLatitude, double toLatitude) {
        super(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
        this.body = body;
        this.fromLatitude = fromLatitude;
        this.toLatitude = toLatitude;
        this.sign = FastMath.signum((double)(toLatitude - fromLatitude));
    }

    @Override
    protected LatitudeRangeCrossingDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new LatitudeRangeCrossingDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.body, this.fromLatitude, this.toLatitude);
    }

    public OneAxisEllipsoid getBody() {
        return this.body;
    }

    public double getFromLatitude() {
        return this.fromLatitude;
    }

    public double getToLatitude() {
        return this.toLatitude;
    }

    @Override
    public double g(SpacecraftState s) {
        GeodeticPoint gp = this.body.transform(s.getPVCoordinates().getPosition(), s.getFrame(), s.getDate());
        double latitude = gp.getLatitude();
        return this.sign * (latitude - this.fromLatitude) * (this.toLatitude - latitude);
    }
}

