/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;

public class LatitudeCrossingDetector
extends AbstractDetector<LatitudeCrossingDetector> {
    private OneAxisEllipsoid body;
    private final double latitude;

    public LatitudeCrossingDetector(OneAxisEllipsoid body, double latitude) {
        this(600.0, 1.0E-6, body, latitude);
    }

    public LatitudeCrossingDetector(double maxCheck, double threshold, OneAxisEllipsoid body, double latitude) {
        this(AdaptableInterval.of(maxCheck), threshold, 100, new StopOnIncreasing(), body, latitude);
    }

    protected LatitudeCrossingDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, OneAxisEllipsoid body, double latitude) {
        super(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
        this.body = body;
        this.latitude = latitude;
    }

    @Override
    protected LatitudeCrossingDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new LatitudeCrossingDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.body, this.latitude);
    }

    public OneAxisEllipsoid getBody() {
        return this.body;
    }

    public double getLatitude() {
        return this.latitude;
    }

    @Override
    public double g(SpacecraftState s) {
        GeodeticPoint gp = this.body.transform(s.getPosition(), s.getFrame(), s.getDate());
        return gp.getLatitude() - this.latitude;
    }
}

