/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.handlers.ContinueOnEvent;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;

public class InterSatDirectViewDetector
extends AbstractDetector<InterSatDirectViewDetector> {
    private final OneAxisEllipsoid body;
    private final double skimmingAltitude;
    private final PVCoordinatesProvider secondary;

    public InterSatDirectViewDetector(OneAxisEllipsoid body, PVCoordinatesProvider secondary) {
        this(body, 0.0, secondary, AdaptableInterval.of(600.0), 1.0E-6, 100, new ContinueOnEvent());
    }

    protected InterSatDirectViewDetector(OneAxisEllipsoid body, double skimmingAltitude, PVCoordinatesProvider secondary, AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler) {
        super(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
        this.body = body;
        this.skimmingAltitude = skimmingAltitude;
        this.secondary = secondary;
    }

    public OneAxisEllipsoid getCentralBody() {
        return this.body;
    }

    public double getSkimmingAltitude() {
        return this.skimmingAltitude;
    }

    public PVCoordinatesProvider getSecondary() {
        return this.secondary;
    }

    @Override
    protected InterSatDirectViewDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new InterSatDirectViewDetector(this.body, this.skimmingAltitude, this.secondary, newMaxCheck, newThreshold, newMaxIter, newHandler);
    }

    public InterSatDirectViewDetector withSkimmingAltitude(double newSkimmingAltitude) {
        return new InterSatDirectViewDetector(this.body, newSkimmingAltitude, this.secondary, this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler());
    }

    @Override
    public double g(SpacecraftState state) {
        AbsoluteDate date = state.getDate();
        Frame frame = this.body.getBodyFrame();
        GeodeticPoint lowest = this.body.lowestAltitudeIntermediate(state.getPosition(frame), this.secondary.getPosition(date, frame));
        return lowest.getAltitude() - this.skimmingAltitude;
    }
}

