/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.util.function.ToDoubleFunction;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.handlers.ContinueOnEvent;
import org.orekit.propagation.events.handlers.EventHandler;

public class FunctionalDetector
extends AbstractDetector<FunctionalDetector> {
    private final ToDoubleFunction<SpacecraftState> function;

    public FunctionalDetector() {
        this(AdaptableInterval.of(600.0), 1.0E-6, 100, new ContinueOnEvent(), value -> 1.0);
    }

    protected FunctionalDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, ToDoubleFunction<SpacecraftState> function) {
        super(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
        this.function = function;
    }

    @Override
    public double g(SpacecraftState s) {
        return this.function.applyAsDouble(s);
    }

    @Override
    protected FunctionalDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new FunctionalDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.function);
    }

    public FunctionalDetector withFunction(ToDoubleFunction<SpacecraftState> newGFunction) {
        return new FunctionalDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), newGFunction);
    }

    public ToDoubleFunction<SpacecraftState> getFunction() {
        return this.function;
    }
}

