/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnEvent;
import org.orekit.utils.FieldPVCoordinatesProvider;

public class FieldRelativeDistanceDetector<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldRelativeDistanceDetector<T>, T> {
    private final FieldPVCoordinatesProvider<T> secondaryPVProvider;
    private final T distanceThreshold;

    public FieldRelativeDistanceDetector(FieldPVCoordinatesProvider<T> secondaryPVProvider, T distanceThreshold) {
        this(FieldAdaptableInterval.of(600.0), (CalculusFieldElement)((CalculusFieldElement)distanceThreshold.getField().getZero()).newInstance(1.0E-6), 100, new FieldStopOnEvent(), (FieldPVCoordinatesProvider<CalculusFieldElement>)secondaryPVProvider, (CalculusFieldElement)distanceThreshold);
    }

    protected FieldRelativeDistanceDetector(FieldEventDetectionSettings<T> detectionSettings, FieldEventHandler<T> handler, FieldPVCoordinatesProvider<T> secondaryPVProvider, T distanceThreshold) {
        super(detectionSettings, handler);
        this.secondaryPVProvider = secondaryPVProvider;
        this.distanceThreshold = distanceThreshold;
    }

    @Deprecated
    protected FieldRelativeDistanceDetector(FieldAdaptableInterval<T> maxCheck, T threshold, int maxIter, FieldEventHandler<T> handler, FieldPVCoordinatesProvider<T> secondaryPVProvider, T distanceThreshold) {
        this(new FieldEventDetectionSettings<T>(maxCheck, threshold, maxIter), handler, secondaryPVProvider, distanceThreshold);
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        FieldVector3D<T> secondaryPosition = this.getSecondaryPVProvider().getPosition(s.getDate(), s.getFrame());
        CalculusFieldElement relativeDistance = s.getPosition().subtract(secondaryPosition).getNorm();
        return (T)((CalculusFieldElement)relativeDistance.subtract(this.distanceThreshold));
    }

    @Override
    protected FieldRelativeDistanceDetector<T> create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> newHandler) {
        return new FieldRelativeDistanceDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.secondaryPVProvider, this.distanceThreshold);
    }

    public FieldPVCoordinatesProvider<T> getSecondaryPVProvider() {
        return this.secondaryPVProvider;
    }

    public T getDistanceThreshold() {
        return this.distanceThreshold;
    }
}

