/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.util.List;
import java.util.stream.Collectors;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnEvent;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.DateDriver;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterObserver;
import org.orekit.utils.TimeSpanMap;

public class FieldParameterDrivenDateIntervalDetector<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldParameterDrivenDateIntervalDetector<T>, T> {
    public static final String START_SUFFIX = "_START";
    public static final String STOP_SUFFIX = "_STOP";
    public static final String MEDIAN_SUFFIX = "_MEDIAN";
    public static final String DURATION_SUFFIX = "_DURATION";
    private DateDriver start;
    private DateDriver stop;
    private DateDriver median;
    private ParameterDriver duration;

    public FieldParameterDrivenDateIntervalDetector(Field<T> field, String prefix, AbsoluteDate refMedian, double refDuration) {
        this(field, prefix, refMedian.shiftedBy(-0.5 * refDuration), refMedian.shiftedBy(0.5 * refDuration));
    }

    public FieldParameterDrivenDateIntervalDetector(Field<T> field, String prefix, AbsoluteDate refStart, AbsoluteDate refStop) {
        this(FieldAdaptableInterval.of(600.0), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(1.0E-6), 100, new FieldStopOnEvent(), new DateDriver(refStart, prefix + START_SUFFIX, true), new DateDriver(refStop, prefix + STOP_SUFFIX, false), new DateDriver(refStart.shiftedBy(0.5 * refStop.durationFrom(refStart)), prefix + MEDIAN_SUFFIX, true), new ParameterDriver(prefix + DURATION_SUFFIX, refStop.durationFrom(refStart), 1.0, 0.0, Double.POSITIVE_INFINITY));
    }

    protected FieldParameterDrivenDateIntervalDetector(FieldAdaptableInterval<T> maxCheck, T threshold, int maxIter, FieldEventHandler<T> handler, DateDriver start, DateDriver stop, DateDriver median, ParameterDriver duration) {
        super(new FieldEventDetectionSettings<T>(maxCheck, threshold, maxIter), handler);
        this.start = start;
        this.stop = stop;
        this.median = median;
        this.duration = duration;
        this.replaceBindingObserver(start, new StartObserver());
        this.replaceBindingObserver(stop, new StopObserver());
        this.replaceBindingObserver(median, new MedianObserver());
        this.replaceBindingObserver(duration, new DurationObserver());
    }

    private void replaceBindingObserver(ParameterDriver driver, BindingObserver bindingObserver) {
        List<ParameterObserver> original = driver.getObservers().stream().filter(observer -> observer instanceof BindingObserver).collect(Collectors.toList());
        original.forEach(observer -> driver.removeObserver((ParameterObserver)observer));
        driver.addObserver(bindingObserver);
    }

    @Override
    protected FieldParameterDrivenDateIntervalDetector<T> create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> newHandler) {
        return new FieldParameterDrivenDateIntervalDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.start, this.stop, this.median, this.duration);
    }

    public DateDriver getStartDriver() {
        return this.start;
    }

    public DateDriver getStopDriver() {
        return this.stop;
    }

    public DateDriver getMedianDriver() {
        return this.median;
    }

    public ParameterDriver getDurationDriver() {
        return this.duration;
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        return (T)FastMath.min(s.getDate().durationFrom(this.start.getDate()), (CalculusFieldElement)((CalculusFieldElement)s.getDate().durationFrom(this.stop.getDate()).negate()));
    }

    private class DurationObserver
    extends BindingObserver {
        private DurationObserver() {
        }

        @Override
        protected void setDelta(double delta, AbsoluteDate date) {
            FieldParameterDrivenDateIntervalDetector.this.start.setValue(FieldParameterDrivenDateIntervalDetector.this.start.getValue(date) - 0.5 * delta, date);
            FieldParameterDrivenDateIntervalDetector.this.stop.setValue(FieldParameterDrivenDateIntervalDetector.this.stop.getValue(date) + 0.5 * delta, date);
        }
    }

    private class MedianObserver
    extends BindingObserver {
        private MedianObserver() {
        }

        @Override
        protected void setDelta(double delta, AbsoluteDate date) {
            FieldParameterDrivenDateIntervalDetector.this.start.setValue(FieldParameterDrivenDateIntervalDetector.this.start.getValue(date) + delta, date);
            FieldParameterDrivenDateIntervalDetector.this.stop.setValue(FieldParameterDrivenDateIntervalDetector.this.stop.getValue(date) + delta, date);
        }
    }

    private class StopObserver
    extends BindingObserver {
        private StopObserver() {
        }

        @Override
        protected void setDelta(double delta, AbsoluteDate date) {
            FieldParameterDrivenDateIntervalDetector.this.median.setValue(FieldParameterDrivenDateIntervalDetector.this.median.getValue(date) + 0.5 * delta, date);
            FieldParameterDrivenDateIntervalDetector.this.duration.setValue(FieldParameterDrivenDateIntervalDetector.this.duration.getValue(date) + delta, date);
        }
    }

    private class StartObserver
    extends BindingObserver {
        private StartObserver() {
        }

        @Override
        protected void setDelta(double delta, AbsoluteDate date) {
            FieldParameterDrivenDateIntervalDetector.this.median.setValue(FieldParameterDrivenDateIntervalDetector.this.median.getValue(date) + 0.5 * delta, date);
            FieldParameterDrivenDateIntervalDetector.this.duration.setValue(FieldParameterDrivenDateIntervalDetector.this.duration.getValue(date) - delta, date);
        }
    }

    private abstract class BindingObserver
    implements ParameterObserver {
        private BindingObserver() {
        }

        @Override
        public void valueChanged(double previousValue, ParameterDriver driver, AbsoluteDate date) {
            if (driver.isSelected()) {
                this.setDelta(driver.getValue(date) - previousValue, date);
            }
        }

        @Override
        public void valueSpanMapChanged(TimeSpanMap<Double> previousValue, ParameterDriver driver) {
            if (driver.isSelected()) {
                for (TimeSpanMap.Span<Double> span = driver.getValueSpanMap().getFirstSpan(); span != null; span = span.next()) {
                    this.setDelta(span.getData() - previousValue.get(span.getStart()), span.getStart());
                }
            }
        }

        @Override
        public void selectionChanged(boolean previousSelection, ParameterDriver driver) {
            if ((FieldParameterDrivenDateIntervalDetector.this.start.isSelected() || FieldParameterDrivenDateIntervalDetector.this.stop.isSelected()) && (FieldParameterDrivenDateIntervalDetector.this.median.isSelected() || FieldParameterDrivenDateIntervalDetector.this.duration.isSelected())) {
                throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_SELECTION, FieldParameterDrivenDateIntervalDetector.this.start.getName(), FieldParameterDrivenDateIntervalDetector.this.stop.getName(), FieldParameterDrivenDateIntervalDetector.this.median.getName(), FieldParameterDrivenDateIntervalDetector.this.duration.getName());
            }
        }

        protected abstract void setDelta(double var1, AbsoluteDate var3);
    }
}

