/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.geometry.fov.FieldOfView;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.VisibilityTrigger;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;
import org.orekit.utils.PVCoordinatesProvider;

public class FieldOfViewDetector
extends AbstractDetector<FieldOfViewDetector> {
    private final PVCoordinatesProvider targetPVProvider;
    private final double radiusTarget;
    private final VisibilityTrigger trigger;
    private final FieldOfView fov;

    public FieldOfViewDetector(PVCoordinatesProvider pvTarget, FieldOfView fov) {
        this(pvTarget, 0.0, VisibilityTrigger.VISIBLE_AS_SOON_AS_PARTIALLY_IN_FOV, fov);
    }

    public FieldOfViewDetector(PVCoordinatesProvider pvTarget, double radiusTarget, VisibilityTrigger trigger, FieldOfView fov) {
        this(AdaptableInterval.of(600.0), 1.0E-6, 100, new StopOnIncreasing(), pvTarget, radiusTarget, trigger, fov);
    }

    protected FieldOfViewDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, PVCoordinatesProvider pvTarget, double radiusTarget, VisibilityTrigger trigger, FieldOfView fov) {
        super(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
        this.targetPVProvider = pvTarget;
        this.radiusTarget = radiusTarget;
        this.trigger = trigger;
        this.fov = fov;
    }

    @Override
    protected FieldOfViewDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new FieldOfViewDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.targetPVProvider, this.radiusTarget, this.trigger, this.fov);
    }

    public PVCoordinatesProvider getPVTarget() {
        return this.targetPVProvider;
    }

    public FieldOfView getFOV() {
        return this.fov;
    }

    @Override
    public double g(SpacecraftState s) {
        Vector3D targetPosInert = this.targetPVProvider.getPosition(s.getDate(), s.getFrame());
        Vector3D lineOfSightSC = s.toStaticTransform().transformPosition(targetPosInert);
        double angularRadius = FastMath.asin((double)(this.radiusTarget / lineOfSightSC.getNorm()));
        return this.fov.offsetFromBoundary(lineOfSightSC, angularRadius, this.trigger);
    }
}

