/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnIncreasing;

public class FieldLongitudeRangeCrossingDetector<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldLongitudeRangeCrossingDetector<T>, T> {
    private final OneAxisEllipsoid body;
    private final double fromLongitude;
    private final double toLongitude;
    private final double sign;

    public FieldLongitudeRangeCrossingDetector(Field<T> field, OneAxisEllipsoid body, double fromLongitude, double toLongitude) {
        this(FieldAdaptableInterval.of(600.0), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(1.0E-6), 100, new FieldStopOnIncreasing(), body, fromLongitude, toLongitude);
    }

    public FieldLongitudeRangeCrossingDetector(T maxCheck, T threshold, OneAxisEllipsoid body, double fromLongitude, double toLongitude) {
        this(FieldAdaptableInterval.of(maxCheck.getReal()), threshold, 100, new FieldStopOnIncreasing(), body, fromLongitude, toLongitude);
    }

    protected FieldLongitudeRangeCrossingDetector(FieldAdaptableInterval<T> maxCheck, T threshold, int maxIter, FieldEventHandler<T> handler, OneAxisEllipsoid body, double fromLongitude, double toLongitude) {
        super(new FieldEventDetectionSettings<T>(maxCheck, threshold, maxIter), handler);
        this.body = body;
        this.fromLongitude = this.ensureLongitudePositiveContinuity(fromLongitude);
        this.toLongitude = this.ensureLongitudePositiveContinuity(toLongitude);
        this.sign = FastMath.signum((double)(this.toLongitude - this.fromLongitude));
    }

    @Override
    protected FieldLongitudeRangeCrossingDetector<T> create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> newHandler) {
        return new FieldLongitudeRangeCrossingDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.body, this.fromLongitude, this.toLongitude);
    }

    public OneAxisEllipsoid getBody() {
        return this.body;
    }

    public double getFromLongitude() {
        return this.getLongitudeOverOriginalRange(this.fromLongitude);
    }

    public double getToLongitude() {
        return this.getLongitudeOverOriginalRange(this.toLongitude);
    }

    private T ensureFieldLongitudePositiveContinuity(T longitude) {
        return (T)(longitude.getReal() < 0.0 ? (CalculusFieldElement)longitude.add(Math.PI * 2) : longitude);
    }

    private double ensureLongitudePositiveContinuity(double longitude) {
        return longitude < 0.0 ? longitude + Math.PI * 2 : longitude;
    }

    private double getLongitudeOverOriginalRange(double longitude) {
        return longitude > Math.PI ? longitude - Math.PI * 2 : longitude;
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        FieldGeodeticPoint gp = this.body.transform(s.getPVCoordinates().getPosition(), s.getFrame(), s.getDate());
        Object longitude = this.ensureFieldLongitudePositiveContinuity(gp.getLongitude());
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)longitude.subtract(this.fromLongitude)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)longitude.negate()).add(this.toLongitude)))).multiply(this.sign));
    }
}

