/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEnablingPredicate;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.FieldEventEnablingPredicateFilter;
import org.orekit.propagation.events.handlers.FieldContinueOnEvent;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnIncreasing;
import org.orekit.time.FieldAbsoluteDate;

public class FieldLongitudeCrossingDetector<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldLongitudeCrossingDetector<T>, T> {
    private OneAxisEllipsoid body;
    private final double longitude;
    private final FieldEventEnablingPredicateFilter<T> filtering;

    public FieldLongitudeCrossingDetector(Field<T> field, OneAxisEllipsoid body, double longitude) {
        this(FieldAdaptableInterval.of(600.0), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(1.0E-6), 100, new FieldStopOnIncreasing(), body, longitude);
    }

    public FieldLongitudeCrossingDetector(T maxCheck, T threshold, OneAxisEllipsoid body, double longitude) {
        this(FieldAdaptableInterval.of(maxCheck.getReal()), threshold, 100, new FieldStopOnIncreasing(), body, longitude);
    }

    protected FieldLongitudeCrossingDetector(FieldAdaptableInterval<T> maxCheck, T threshold, int maxIter, FieldEventHandler<T> handler, OneAxisEllipsoid body, double longitude) {
        super(new FieldEventDetectionSettings<T>(maxCheck, threshold, maxIter), handler);
        this.body = body;
        this.longitude = longitude;
        FieldRawLongitudeCrossingDetector raw = new FieldRawLongitudeCrossingDetector(this, maxCheck, threshold, maxIter, new FieldContinueOnEvent());
        FieldEnablingPredicate<CalculusFieldElement> predicate = (state, detector, g) -> FastMath.abs((CalculusFieldElement)g).getReal() < 1.5707963267948966;
        this.filtering = new FieldEventEnablingPredicateFilter<CalculusFieldElement>(raw, predicate);
    }

    @Override
    protected FieldLongitudeCrossingDetector<T> create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> newHandler) {
        return new FieldLongitudeCrossingDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.body, this.longitude);
    }

    public OneAxisEllipsoid getBody() {
        return this.body;
    }

    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public void init(FieldSpacecraftState<T> s0, FieldAbsoluteDate<T> t) {
        this.filtering.init(s0, t);
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        return this.filtering.g(s);
    }

    private static class FieldRawLongitudeCrossingDetector<TT extends CalculusFieldElement<TT>>
    extends FieldAbstractDetector<FieldRawLongitudeCrossingDetector<TT>, TT> {
        final /* synthetic */ FieldLongitudeCrossingDetector this$0;

        protected FieldRawLongitudeCrossingDetector(FieldAdaptableInterval<TT> maxCheck, TT threshold, int maxIter, FieldEventHandler<TT> handler) {
            this.this$0 = var1_1;
            super(new FieldEventDetectionSettings<TT>(maxCheck, threshold, maxIter), handler);
        }

        @Override
        protected FieldRawLongitudeCrossingDetector<TT> create(FieldAdaptableInterval<TT> newMaxCheck, TT newThreshold, int newMaxIter, FieldEventHandler<TT> newHandler) {
            return new FieldRawLongitudeCrossingDetector(this.this$0, newMaxCheck, newThreshold, newMaxIter, newHandler);
        }

        @Override
        public TT g(FieldSpacecraftState<TT> s) {
            FieldGeodeticPoint<TT> gp = this.this$0.body.transform(s.getPosition(), s.getFrame(), s.getDate());
            CalculusFieldElement zero = (CalculusFieldElement)gp.getLongitude().getField().getZero();
            return (TT)MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)gp.getLongitude().subtract(this.this$0.longitude)), (CalculusFieldElement)zero);
        }
    }
}

