/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnIncreasing;

public class FieldLatitudeRangeCrossingDetector<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldLatitudeRangeCrossingDetector<T>, T> {
    private final OneAxisEllipsoid body;
    private final double fromLatitude;
    private final double toLatitude;
    private final double sign;

    public FieldLatitudeRangeCrossingDetector(Field<T> field, OneAxisEllipsoid body, double fromLatitude, double toLatitude) {
        this(FieldAdaptableInterval.of(600.0), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(1.0E-6), 100, new FieldStopOnIncreasing(), body, fromLatitude, toLatitude);
    }

    public FieldLatitudeRangeCrossingDetector(T maxCheck, T threshold, OneAxisEllipsoid body, double fromLatitude, double toLatitude) {
        this(FieldAdaptableInterval.of(maxCheck.getReal()), threshold, 100, new FieldStopOnIncreasing(), body, fromLatitude, toLatitude);
    }

    protected FieldLatitudeRangeCrossingDetector(FieldAdaptableInterval<T> maxCheck, T threshold, int maxIter, FieldEventHandler<T> handler, OneAxisEllipsoid body, double fromLatitude, double toLatitude) {
        super(new FieldEventDetectionSettings<T>(maxCheck, threshold, maxIter), handler);
        this.body = body;
        this.fromLatitude = fromLatitude;
        this.toLatitude = toLatitude;
        this.sign = FastMath.signum((double)(toLatitude - fromLatitude));
    }

    @Override
    protected FieldLatitudeRangeCrossingDetector<T> create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> newHandler) {
        return new FieldLatitudeRangeCrossingDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.body, this.fromLatitude, this.toLatitude);
    }

    public OneAxisEllipsoid getBody() {
        return this.body;
    }

    public double getFromLatitude() {
        return this.fromLatitude;
    }

    public double getToLatitude() {
        return this.toLatitude;
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        FieldGeodeticPoint gp = this.body.transform(s.getPVCoordinates().getPosition(), s.getFrame(), s.getDate());
        Object latitude = gp.getLatitude();
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)latitude.subtract(this.fromLatitude)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)latitude.negate()).add(this.toLatitude)))).multiply(this.sign));
    }
}

