/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnIncreasing;

public class FieldLatitudeCrossingDetector<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldLatitudeCrossingDetector<T>, T> {
    private OneAxisEllipsoid body;
    private final double latitude;

    public FieldLatitudeCrossingDetector(Field<T> field, OneAxisEllipsoid body, double latitude) {
        this(FieldAdaptableInterval.of(600.0), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(1.0E-6), 100, new FieldStopOnIncreasing(), body, latitude);
    }

    public FieldLatitudeCrossingDetector(T maxCheck, T threshold, OneAxisEllipsoid body, double latitude) {
        this(FieldAdaptableInterval.of(maxCheck.getReal()), threshold, 100, new FieldStopOnIncreasing(), body, latitude);
    }

    protected FieldLatitudeCrossingDetector(FieldAdaptableInterval<T> maxCheck, T threshold, int maxIter, FieldEventHandler<T> handler, OneAxisEllipsoid body, double latitude) {
        super(new FieldEventDetectionSettings<T>(maxCheck, threshold, maxIter), handler);
        this.body = body;
        this.latitude = latitude;
    }

    @Override
    protected FieldLatitudeCrossingDetector<T> create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> newHandler) {
        return new FieldLatitudeCrossingDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.body, this.latitude);
    }

    public OneAxisEllipsoid getBody() {
        return this.body;
    }

    public double getLatitude() {
        return this.latitude;
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        FieldGeodeticPoint<T> gp = this.body.transform(s.getPosition(), s.getFrame(), s.getDate());
        return (T)((CalculusFieldElement)gp.getLatitude().subtract(this.latitude));
    }
}

