/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.util.function.Function;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.handlers.FieldContinueOnEvent;
import org.orekit.propagation.events.handlers.FieldEventHandler;

public class FieldFunctionalDetector<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldFunctionalDetector<T>, T> {
    private final Function<FieldSpacecraftState<T>, T> function;

    public FieldFunctionalDetector(Field<T> field) {
        this(FieldAdaptableInterval.of(600.0), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(1.0E-6), 100, new FieldContinueOnEvent(), value -> (CalculusFieldElement)field.getOne());
    }

    protected FieldFunctionalDetector(FieldAdaptableInterval<T> maxCheck, T threshold, int maxIter, FieldEventHandler<T> handler, Function<FieldSpacecraftState<T>, T> function) {
        super(new FieldEventDetectionSettings<T>(maxCheck, threshold, maxIter), handler);
        this.function = function;
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        return (T)((CalculusFieldElement)this.function.apply(s));
    }

    @Override
    protected FieldFunctionalDetector<T> create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> newHandler) {
        return new FieldFunctionalDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.function);
    }

    public FieldFunctionalDetector<T> withFunction(Function<FieldSpacecraftState<T>, T> newGFunction) {
        return new FieldFunctionalDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), newGFunction);
    }

    public Function<FieldSpacecraftState<T>, T> getFunction() {
        return this.function;
    }
}

