/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.frames.Frame;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnIncreasing;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class FieldExtremumApproachDetector<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldExtremumApproachDetector<T>, T> {
    private final FieldPVCoordinatesProvider<T> secondaryPVProvider;

    public FieldExtremumApproachDetector(Field<T> field, PVCoordinatesProvider secondaryPVProvider) {
        this(field, (FieldAbsoluteDate<T> date, Frame frame) -> {
            TimeStampedPVCoordinates timeStampedPV = secondaryPVProvider.getPVCoordinates(date.toAbsoluteDate(), frame);
            return new TimeStampedFieldPVCoordinates(field, timeStampedPV);
        });
    }

    public FieldExtremumApproachDetector(Field<T> field, FieldPVCoordinatesProvider<T> secondaryPVProvider) {
        this((CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(600.0), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(1.0E-6), 100, new FieldStopOnIncreasing(), secondaryPVProvider);
    }

    protected FieldExtremumApproachDetector(T maxCheck, T threshold, int maxIter, FieldEventHandler<T> handler, FieldPVCoordinatesProvider<T> secondaryPVProvider) {
        this(FieldAdaptableInterval.of(maxCheck.getReal()), threshold, maxIter, handler, secondaryPVProvider);
    }

    protected FieldExtremumApproachDetector(FieldAdaptableInterval<T> maxCheck, T threshold, int maxIter, FieldEventHandler<T> handler, FieldPVCoordinatesProvider<T> secondaryPVProvider) {
        super(new FieldEventDetectionSettings<T>(maxCheck, threshold, maxIter), handler);
        this.secondaryPVProvider = secondaryPVProvider;
    }

    @Deprecated
    public FieldPVCoordinates<T> computeDeltaPV(FieldSpacecraftState<T> s) {
        FieldVector3D<T> primaryPos = s.getPosition();
        FieldVector3D primaryVel = s.getPVCoordinates().getVelocity();
        TimeStampedFieldPVCoordinates<T> secondaryPV = this.secondaryPVProvider.getPVCoordinates(s.getDate(), s.getFrame());
        FieldVector3D secondaryPos = secondaryPV.getPosition();
        FieldVector3D secondaryVel = secondaryPV.getVelocity();
        FieldVector3D relativePos = secondaryPos.subtract(primaryPos);
        FieldVector3D relativeVel = secondaryVel.subtract(primaryVel);
        return new FieldPVCoordinates(relativePos, relativeVel);
    }

    public FieldPVCoordinatesProvider<T> getSecondaryPVProvider() {
        return this.secondaryPVProvider;
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        FieldPVCoordinates<T> deltaPV = this.computeDeltaPV(s);
        return (T)FieldVector3D.dotProduct(deltaPV.getPosition(), deltaPV.getVelocity());
    }

    @Override
    protected FieldExtremumApproachDetector<T> create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> newHandler) {
        return new FieldExtremumApproachDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.secondaryPVProvider);
    }
}

