/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.ode.events.Action;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.time.FieldAbsoluteDate;

public class FieldEventsLogger<T extends CalculusFieldElement<T>> {
    private final List<FieldLoggedEvent<T>> log = new ArrayList<FieldLoggedEvent<T>>();

    public FieldAbstractDetector<FieldLoggingWrapper, T> monitorDetector(FieldEventDetector<T> monitoredDetector) {
        return new FieldLoggingWrapper(monitoredDetector);
    }

    public void clearLoggedEvents() {
        this.log.clear();
    }

    public List<FieldLoggedEvent<T>> getLoggedEvents() {
        return new ArrayList<FieldLoggedEvent<T>>(this.log);
    }

    private class FieldLoggingWrapper
    extends FieldAbstractDetector<FieldLoggingWrapper, T> {
        private final FieldEventDetector<T> detector;

        FieldLoggingWrapper(FieldEventDetector<T> detector) {
            this(detector.getDetectionSettings(), null, detector);
        }

        private FieldLoggingWrapper(FieldEventDetectionSettings<T> detectionSettings, FieldEventHandler<T> handler, FieldEventDetector<T> detector) {
            super(detectionSettings, handler);
            this.detector = detector;
        }

        @Override
        protected FieldLoggingWrapper create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> newHandler) {
            return new FieldLoggingWrapper(new FieldEventDetectionSettings(newMaxCheck, newThreshold, newMaxIter), newHandler, this.detector);
        }

        public void logEvent(FieldSpacecraftState<T> state, boolean increasing) {
            FieldEventsLogger.this.log.add(new FieldLoggedEvent(this.detector, state, increasing));
        }

        @Override
        public void init(FieldSpacecraftState<T> s0, FieldAbsoluteDate<T> t) {
            super.init(s0, t);
            this.detector.init(s0, t);
        }

        @Override
        public T g(FieldSpacecraftState<T> s) {
            return this.detector.g(s);
        }

        @Override
        public void finish(FieldSpacecraftState<T> state) {
            this.detector.finish(state);
        }

        @Override
        public FieldEventHandler<T> getHandler() {
            final FieldEventHandler handler = this.detector.getHandler();
            return new FieldEventHandler<T>(){

                @Override
                public Action eventOccurred(FieldSpacecraftState<T> s, FieldEventDetector<T> d, boolean increasing) {
                    FieldLoggingWrapper.this.logEvent(s, increasing);
                    return handler.eventOccurred(s, FieldLoggingWrapper.this.detector, increasing);
                }

                @Override
                public FieldSpacecraftState<T> resetState(FieldEventDetector<T> d, FieldSpacecraftState<T> oldState) {
                    return handler.resetState(FieldLoggingWrapper.this.detector, oldState);
                }
            };
        }
    }

    public static class FieldLoggedEvent<T extends CalculusFieldElement<T>> {
        private final FieldEventDetector<T> detector;
        private final FieldSpacecraftState<T> state;
        private final boolean increasing;

        private FieldLoggedEvent(FieldEventDetector<T> detectorN, FieldSpacecraftState<T> stateN, boolean increasingN) {
            this.detector = detectorN;
            this.state = stateN;
            this.increasing = increasingN;
        }

        public FieldEventDetector<T> getEventDetector() {
            return this.detector;
        }

        public FieldSpacecraftState<T> getState() {
            return this.state;
        }

        public boolean isIncreasing() {
            return this.increasing;
        }
    }
}

