/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.ode.events.Action;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEnablingPredicate;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.Transformer;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.time.FieldAbsoluteDate;

public class FieldEventEnablingPredicateFilter<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldEventEnablingPredicateFilter<T>, T> {
    private static final int HISTORY_SIZE = 100;
    private final FieldEventDetector<T> rawDetector;
    private final FieldEnablingPredicate<T> enabler;
    private final Transformer[] transformers;
    private final FieldAbsoluteDate<T>[] updates;
    private boolean forward;
    private FieldAbsoluteDate<T> extremeT;
    private T extremeG;

    public FieldEventEnablingPredicateFilter(FieldEventDetector<T> rawDetector, FieldEnablingPredicate<T> enabler) {
        this(rawDetector.getMaxCheckInterval(), rawDetector.getThreshold(), rawDetector.getMaxIterationCount(), new LocalHandler(), rawDetector, enabler);
    }

    protected FieldEventEnablingPredicateFilter(FieldAdaptableInterval<T> maxCheck, T threshold, int maxIter, FieldEventHandler<T> handler, FieldEventDetector<T> rawDetector, FieldEnablingPredicate<T> enabler) {
        super(new FieldEventDetectionSettings<T>(maxCheck, threshold, maxIter), handler);
        this.rawDetector = rawDetector;
        this.enabler = enabler;
        this.transformers = new Transformer[100];
        this.updates = (FieldAbsoluteDate[])Array.newInstance(FieldAbsoluteDate.class, 100);
    }

    @Override
    protected FieldEventEnablingPredicateFilter<T> create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> newHandler) {
        return new FieldEventEnablingPredicateFilter<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.rawDetector, this.enabler);
    }

    public FieldEventDetector<T> getDetector() {
        return this.rawDetector;
    }

    @Override
    public void init(FieldSpacecraftState<T> s0, FieldAbsoluteDate<T> t) {
        super.init(s0, t);
        this.rawDetector.init(s0, t);
        this.forward = t.compareTo(s0.getDate()) >= 0;
        this.extremeT = this.forward ? FieldAbsoluteDate.getPastInfinity(t.getField()) : FieldAbsoluteDate.getFutureInfinity(t.getField());
        this.extremeG = (CalculusFieldElement)((CalculusFieldElement)t.getField().getZero()).newInstance(Double.NaN);
        Arrays.fill((Object[])this.transformers, (Object)Transformer.UNINITIALIZED);
        Arrays.fill(this.updates, this.extremeT);
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        T rawG = this.rawDetector.g(s);
        boolean isEnabled = this.enabler.eventIsEnabled(s, this.rawDetector, rawG);
        if (this.extremeG.isNaN()) {
            this.extremeG = rawG;
        }
        if (this.forward) {
            int last = this.transformers.length - 1;
            if (this.extremeT.compareTo(s.getDate()) < 0) {
                Transformer previous = this.transformers[last];
                Transformer next = this.selectTransformer(previous, this.extremeG, isEnabled);
                if (next != previous) {
                    System.arraycopy(this.updates, 1, this.updates, 0, last);
                    System.arraycopy(this.transformers, 1, this.transformers, 0, last);
                    this.updates[last] = this.extremeT;
                    this.transformers[last] = next;
                }
                this.extremeT = s.getDate();
                this.extremeG = rawG;
                return next.transformed(rawG);
            }
            for (int i = last; i > 0; --i) {
                if (this.updates[i].compareTo(s.getDate()) > 0) continue;
                return this.transformers[i].transformed(rawG);
            }
            return this.transformers[0].transformed(rawG);
        }
        if (s.getDate().compareTo(this.extremeT) < 0) {
            Transformer previous = this.transformers[0];
            Transformer next = this.selectTransformer(previous, this.extremeG, isEnabled);
            if (next != previous) {
                System.arraycopy(this.updates, 0, this.updates, 1, this.updates.length - 1);
                System.arraycopy(this.transformers, 0, this.transformers, 1, this.transformers.length - 1);
                this.updates[0] = this.extremeT;
                this.transformers[0] = next;
            }
            this.extremeT = s.getDate();
            this.extremeG = rawG;
            return next.transformed(rawG);
        }
        for (int i = 0; i < this.updates.length - 1; ++i) {
            if (s.getDate().compareTo(this.updates[i]) > 0) continue;
            return this.transformers[i].transformed(rawG);
        }
        return this.transformers[this.updates.length - 1].transformed(rawG);
    }

    private Transformer selectTransformer(Transformer previous, T previousG, boolean isEnabled) {
        if (isEnabled) {
            switch (previous) {
                case UNINITIALIZED: {
                    return Transformer.PLUS;
                }
                case MIN: {
                    return previousG.getReal() >= 0.0 ? Transformer.MINUS : Transformer.PLUS;
                }
                case MAX: {
                    return previousG.getReal() >= 0.0 ? Transformer.PLUS : Transformer.MINUS;
                }
            }
            return previous;
        }
        switch (previous) {
            case UNINITIALIZED: {
                return Transformer.MAX;
            }
            case PLUS: {
                return previousG.getReal() >= 0.0 ? Transformer.MAX : Transformer.MIN;
            }
            case MINUS: {
                return previousG.getReal() >= 0.0 ? Transformer.MIN : Transformer.MAX;
            }
        }
        return previous;
    }

    private static class LocalHandler<T extends CalculusFieldElement<T>>
    implements FieldEventHandler<T> {
        private LocalHandler() {
        }

        @Override
        public Action eventOccurred(FieldSpacecraftState<T> s, FieldEventDetector<T> detector, boolean increasing) {
            FieldEventEnablingPredicateFilter ef = (FieldEventEnablingPredicateFilter)detector;
            Transformer transformer = ef.forward ? ef.transformers[ef.transformers.length - 1] : ef.transformers[0];
            return ef.rawDetector.getHandler().eventOccurred(s, ef.rawDetector, transformer == Transformer.PLUS ? increasing : !increasing);
        }

        @Override
        public FieldSpacecraftState<T> resetState(FieldEventDetector<T> detector, FieldSpacecraftState<T> oldState) {
            FieldEventEnablingPredicateFilter ef = (FieldEventEnablingPredicateFilter)detector;
            return ef.rawDetector.getHandler().resetState(ef.rawDetector, oldState);
        }
    }
}

