/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.FieldAdaptableInterval;

public class FieldEventDetectionSettings<T extends CalculusFieldElement<T>> {
    public static final double DEFAULT_MAXCHECK = 600.0;
    public static final double DEFAULT_THRESHOLD = 1.0E-6;
    public static final int DEFAULT_MAX_ITER = 100;
    private final FieldAdaptableInterval<T> maxCheckInterval;
    private final T threshold;
    private final int maxIterationCount;

    public FieldEventDetectionSettings(FieldAdaptableInterval<T> maxCheckInterval, T threshold, int maxIterationCount) {
        this.maxCheckInterval = maxCheckInterval;
        this.maxIterationCount = maxIterationCount;
        this.threshold = threshold;
    }

    public FieldEventDetectionSettings(double maxCheck, T threshold, int maxIterationCount) {
        this(FieldAdaptableInterval.of(maxCheck), threshold, maxIterationCount);
    }

    public FieldEventDetectionSettings(Field<T> field, EventDetectionSettings eventDetectionSettings) {
        this(state -> eventDetectionSettings.getMaxCheckInterval().currentInterval(state.toSpacecraftState()), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(eventDetectionSettings.getThreshold()), eventDetectionSettings.getMaxIterationCount());
    }

    public FieldAdaptableInterval<T> getMaxCheckInterval() {
        return this.maxCheckInterval;
    }

    public T getThreshold() {
        return this.threshold;
    }

    public int getMaxIterationCount() {
        return this.maxIterationCount;
    }

    public EventDetectionSettings toEventDetectionSettings() {
        return new EventDetectionSettings(state -> this.getMaxCheckInterval().currentInterval(new FieldSpacecraftState(this.getThreshold().getField(), state)), this.getThreshold().getReal(), this.getMaxIterationCount());
    }
}

