/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative1;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.frames.FieldKinematicTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.TopocentricFrame;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnIncreasing;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldElevationExtremumDetector<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldElevationExtremumDetector<T>, T> {
    private final TopocentricFrame topo;

    public FieldElevationExtremumDetector(Field<T> field, TopocentricFrame topo) {
        this((CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(600.0), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(1.0E-6), topo);
    }

    public FieldElevationExtremumDetector(T maxCheck, T threshold, TopocentricFrame topo) {
        this(FieldAdaptableInterval.of(maxCheck.getReal()), threshold, 100, new FieldStopOnIncreasing(), topo);
    }

    protected FieldElevationExtremumDetector(FieldAdaptableInterval<T> maxCheck, T threshold, int maxIter, FieldEventHandler<T> handler, TopocentricFrame topo) {
        super(new FieldEventDetectionSettings<T>(maxCheck, threshold, maxIter), handler);
        this.topo = topo;
    }

    @Override
    protected FieldElevationExtremumDetector<T> create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> newHandler) {
        return new FieldElevationExtremumDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.topo);
    }

    public TopocentricFrame getTopocentricFrame() {
        return this.topo;
    }

    public T getElevation(FieldSpacecraftState<T> s) {
        return this.topo.getElevation(s.getPosition(), s.getFrame(), s.getDate());
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        FieldKinematicTransform<T> inertToTopo = s.getFrame().getKinematicTransformTo((Frame)this.topo, s.getDate());
        TimeStampedFieldPVCoordinates<T> pvTopo = inertToTopo.transformOnlyPV(s.getPVCoordinates());
        FieldVector3D pvDS = pvTopo.toUnivariateDerivative1Vector();
        FieldUnivariateDerivative1 elevation = (FieldUnivariateDerivative1)((FieldUnivariateDerivative1)pvDS.getZ()).divide((FieldUnivariateDerivative1)pvDS.getNorm()).asin();
        return (T)elevation.getDerivative(1);
    }
}

