/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.TopocentricFrame;
import org.orekit.models.AtmosphericRefractionModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnDecreasing;
import org.orekit.utils.ElevationMask;

public class FieldElevationDetector<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldElevationDetector<T>, T> {
    private final ElevationMask elevationMask;
    private final double minElevation;
    private final AtmosphericRefractionModel refractionModel;
    private final TopocentricFrame topo;

    public FieldElevationDetector(Field<T> field, TopocentricFrame topo) {
        this(FieldAdaptableInterval.of(600.0), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(1.0E-6), 100, new FieldStopOnDecreasing(), 0.0, null, null, topo);
    }

    public FieldElevationDetector(T maxCheck, T threshold, TopocentricFrame topo) {
        this(FieldAdaptableInterval.of(maxCheck.getReal()), threshold, 100, new FieldStopOnDecreasing(), 0.0, null, null, topo);
    }

    protected FieldElevationDetector(FieldEventDetectionSettings<T> detectionSettings, FieldEventHandler<T> handler, double minElevation, ElevationMask mask, AtmosphericRefractionModel refractionModel, TopocentricFrame topo) {
        super(detectionSettings, handler);
        this.minElevation = minElevation;
        this.elevationMask = mask;
        this.refractionModel = refractionModel;
        this.topo = topo;
    }

    @Deprecated
    protected FieldElevationDetector(FieldAdaptableInterval<T> maxCheck, T threshold, int maxIter, FieldEventHandler<T> handler, double minElevation, ElevationMask mask, AtmosphericRefractionModel refractionModel, TopocentricFrame topo) {
        this(new FieldEventDetectionSettings<T>(maxCheck, threshold, maxIter), handler, minElevation, mask, refractionModel, topo);
    }

    @Override
    protected FieldElevationDetector<T> create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> newHandler) {
        return new FieldElevationDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.minElevation, this.elevationMask, this.refractionModel, this.topo);
    }

    public ElevationMask getElevationMask() {
        return this.elevationMask;
    }

    public double getMinElevation() {
        return this.minElevation;
    }

    public AtmosphericRefractionModel getRefractionModel() {
        return this.refractionModel;
    }

    public TopocentricFrame getTopocentricFrame() {
        return this.topo;
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        FieldStaticTransform<T> t = s.getFrame().getStaticTransformTo((Frame)this.topo, s.getDate());
        FieldVector3D<T> extPointTopo = t.transformPosition(s.getPosition());
        CalculusFieldElement trueElevation = extPointTopo.getDelta();
        CalculusFieldElement calculatedElevation = this.refractionModel != null ? (CalculusFieldElement)trueElevation.add(this.refractionModel.getRefraction(trueElevation.getReal())) : trueElevation;
        if (this.elevationMask != null) {
            double azimuth = FastMath.atan2((double)extPointTopo.getY().getReal(), (double)extPointTopo.getX().getReal());
            return (T)((CalculusFieldElement)calculatedElevation.subtract(this.elevationMask.getElevation(azimuth)));
        }
        return (T)((CalculusFieldElement)calculatedElevation.subtract(this.minElevation));
    }

    public FieldElevationDetector<T> withConstantElevation(double newMinElevation) {
        return new FieldElevationDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), newMinElevation, null, this.refractionModel, this.topo);
    }

    public FieldElevationDetector<T> withElevationMask(ElevationMask newElevationMask) {
        return new FieldElevationDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), Double.NaN, newElevationMask, this.refractionModel, this.topo);
    }

    public FieldElevationDetector<T> withRefraction(AtmosphericRefractionModel newRefractionModel) {
        return new FieldElevationDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), this.minElevation, this.elevationMask, newRefractionModel, this.topo);
    }
}

