/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnIncreasing;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.OccultationEngine;

public class FieldEclipseDetector<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldEclipseDetector<T>, T> {
    private final OccultationEngine occultationEngine;
    private boolean totalEclipse;
    private final T margin;

    public FieldEclipseDetector(Field<T> field, ExtendedPVCoordinatesProvider occulted, double occultedRadius, OneAxisEllipsoid occulting) {
        this(field, new OccultationEngine(occulted, occultedRadius, occulting));
    }

    public FieldEclipseDetector(Field<T> field, OccultationEngine occultationEngine) {
        this(FieldAdaptableInterval.of(600.0), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(1.0E-6), 100, new FieldStopOnIncreasing(), occultationEngine, (CalculusFieldElement)field.getZero(), true);
    }

    protected FieldEclipseDetector(FieldAdaptableInterval<T> maxCheck, T threshold, int maxIter, FieldEventHandler<T> handler, OccultationEngine occultationEngine, T margin, boolean totalEclipse) {
        super(new FieldEventDetectionSettings<T>(maxCheck, threshold, maxIter), handler);
        this.occultationEngine = occultationEngine;
        this.margin = margin;
        this.totalEclipse = totalEclipse;
    }

    @Override
    protected FieldEclipseDetector<T> create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int nawMaxIter, FieldEventHandler<T> newHandler) {
        return new FieldEclipseDetector<T>(newMaxCheck, newThreshold, nawMaxIter, newHandler, this.occultationEngine, this.margin, this.totalEclipse);
    }

    public FieldEclipseDetector<T> withUmbra() {
        return new FieldEclipseDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), this.occultationEngine, this.margin, true);
    }

    public FieldEclipseDetector<T> withPenumbra() {
        return new FieldEclipseDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), this.occultationEngine, this.margin, false);
    }

    public FieldEclipseDetector<T> withMargin(T newMargin) {
        return new FieldEclipseDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), this.occultationEngine, newMargin, this.totalEclipse);
    }

    public T getMargin() {
        return this.margin;
    }

    public OccultationEngine getOccultationEngine() {
        return this.occultationEngine;
    }

    public boolean getTotalEclipse() {
        return this.totalEclipse;
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        OccultationEngine.FieldOccultationAngles<T> angles = this.occultationEngine.angles(s);
        return (T)(this.totalEclipse ? (CalculusFieldElement)((CalculusFieldElement)angles.getSeparation().subtract(angles.getLimbRadius())).add((FieldElement)((CalculusFieldElement)angles.getOccultedApparentRadius().add(this.margin))) : (CalculusFieldElement)((CalculusFieldElement)angles.getSeparation().subtract(angles.getLimbRadius())).subtract((FieldElement)((CalculusFieldElement)angles.getOccultedApparentRadius().add(this.margin))));
    }
}

