/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnEvent;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeStamped;

public class FieldDateDetector<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldDateDetector<T>, T>
implements FieldTimeStamped<T> {
    public static final double DEFAULT_MAX_CHECK = 1.0E10;
    public static final double DEFAULT_MIN_GAP = 1.0;
    public static final double DEFAULT_THRESHOLD = 1.0E-13;
    private final double minGap;
    private FieldAbsoluteDate<T> gDate = null;
    private final ArrayList<FieldEventDate<T>> eventDateList;
    private int currentIndex = -1;

    @SafeVarargs
    public FieldDateDetector(Field<T> field, FieldTimeStamped<T> ... dates) {
        this(FieldAdaptableInterval.of(1.0E10), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(1.0E-13), 100, new FieldStopOnEvent(), 1.0, dates);
    }

    @SafeVarargs
    protected FieldDateDetector(FieldAdaptableInterval<T> maxCheck, T threshold, int maxIter, FieldEventHandler<T> handler, double minGap, FieldTimeStamped<T> ... dates) {
        super(new FieldEventDetectionSettings<T>(maxCheck, threshold, maxIter), handler);
        this.eventDateList = new ArrayList(dates.length);
        for (FieldTimeStamped<T> ts : dates) {
            this.addEventDate(ts.getDate());
        }
        this.minGap = minGap;
    }

    public FieldDateDetector<T> withMinGap(double newMinGap) {
        FieldTimeStamped[] dates = this.eventDateList.toArray(new FieldEventDate[this.eventDateList.size()]);
        return new FieldDateDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), newMinGap, dates);
    }

    @Override
    protected FieldDateDetector<T> create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> newHandler) {
        FieldTimeStamped[] dates = this.eventDateList.toArray(new FieldEventDate[this.eventDateList.size()]);
        return new FieldDateDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.minGap, dates);
    }

    public List<FieldTimeStamped<T>> getDates() {
        return Collections.unmodifiableList(this.eventDateList);
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        this.gDate = s.getDate();
        if (this.currentIndex < 0) {
            return (T)((CalculusFieldElement)((CalculusFieldElement)s.getA().getField().getZero()).newInstance(-1.0));
        }
        FieldEventDate<T> event = this.getClosest(this.gDate);
        return event.isgIncrease() ? this.gDate.durationFrom(event.getDate()) : event.getDate().durationFrom(this.gDate);
    }

    @Override
    public FieldAbsoluteDate<T> getDate() {
        return this.currentIndex < 0 ? null : this.eventDateList.get(this.currentIndex).getDate();
    }

    public void addEventDate(FieldAbsoluteDate<T> target) throws IllegalArgumentException {
        if (this.currentIndex < 0) {
            boolean increasing = this.gDate == null ? true : target.durationFrom(this.gDate).getReal() > 0.0;
            this.currentIndex = 0;
            this.eventDateList.add(new FieldEventDate<T>(target, increasing));
        } else {
            int lastIndex = this.eventDateList.size() - 1;
            FieldAbsoluteDate<T> firstDate = this.eventDateList.get(0).getDate();
            FieldAbsoluteDate<T> lastDate = this.eventDateList.get(lastIndex).getDate();
            if (firstDate.durationFrom(target).getReal() > this.minGap) {
                boolean increasing = !this.eventDateList.get(0).isgIncrease();
                this.eventDateList.add(0, new FieldEventDate<T>(target, increasing));
                ++this.currentIndex;
            } else if (target.durationFrom(lastDate).getReal() > this.minGap) {
                boolean increasing = !this.eventDateList.get(lastIndex).isgIncrease();
                this.eventDateList.add(new FieldEventDate<T>(target, increasing));
            } else {
                throw new OrekitIllegalArgumentException(OrekitMessages.EVENT_DATE_TOO_CLOSE, target, firstDate, lastDate, this.minGap, firstDate.durationFrom(target), target.durationFrom(lastDate));
            }
        }
    }

    private FieldEventDate<T> getClosest(FieldAbsoluteDate<T> target) {
        block5: {
            T dt;
            block4: {
                dt = target.durationFrom(this.eventDateList.get(this.currentIndex).getDate());
                if (!(dt.getReal() < 0.0) || this.currentIndex <= 0) break block4;
                boolean found = false;
                while (this.currentIndex > 0 && !found) {
                    if (target.durationFrom(this.eventDateList.get(this.currentIndex - 1).getDate()).getReal() < this.eventDateList.get(this.currentIndex).getDate().durationFrom(target).getReal()) {
                        --this.currentIndex;
                        continue;
                    }
                    found = true;
                }
                break block5;
            }
            if (!(dt.getReal() > 0.0) || this.currentIndex >= this.eventDateList.size() - 1) break block5;
            int maxIndex = this.eventDateList.size() - 1;
            boolean found = false;
            while (this.currentIndex < maxIndex && !found) {
                if (target.durationFrom(this.eventDateList.get(this.currentIndex + 1).getDate()).getReal() > this.eventDateList.get(this.currentIndex).getDate().durationFrom(target).getReal()) {
                    ++this.currentIndex;
                    continue;
                }
                found = true;
            }
        }
        return this.eventDateList.get(this.currentIndex);
    }

    private static class FieldEventDate<T extends CalculusFieldElement<T>>
    implements FieldTimeStamped<T> {
        private final FieldAbsoluteDate<T> eventDate;
        private final boolean gIncrease;

        FieldEventDate(FieldAbsoluteDate<T> date, boolean increase) {
            this.eventDate = date;
            this.gIncrease = increase;
        }

        @Override
        public FieldAbsoluteDate<T> getDate() {
            return this.eventDate;
        }

        public boolean isgIncrease() {
            return this.gIncrease;
        }
    }
}

