/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.utils.ExtendedPositionProvider;

public class FieldCylindricalShadowEclipseDetector<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldCylindricalShadowEclipseDetector<T>, T> {
    private final ExtendedPositionProvider sun;
    private final T occultingBodyRadius;

    public FieldCylindricalShadowEclipseDetector(ExtendedPositionProvider sun, T occultingBodyRadius, FieldEventDetectionSettings<T> eventDetectionSettings, FieldEventHandler<T> handler) {
        super(eventDetectionSettings, handler);
        this.sun = sun;
        this.occultingBodyRadius = FastMath.abs(occultingBodyRadius);
    }

    @Deprecated
    public FieldCylindricalShadowEclipseDetector(ExtendedPositionProvider sun, T occultingBodyRadius, FieldAdaptableInterval<T> maxCheck, T threshold, int maxIter, FieldEventHandler<T> handler) {
        this(sun, occultingBodyRadius, new FieldEventDetectionSettings<T>(maxCheck, threshold, maxIter), handler);
    }

    public FieldCylindricalShadowEclipseDetector(ExtendedPositionProvider sun, T occultingBodyRadius, FieldEventHandler<T> handler) {
        this(sun, occultingBodyRadius, new FieldEventDetectionSettings(occultingBodyRadius.getField(), EventDetectionSettings.getDefaultEventDetectionSettings()), handler);
    }

    public T getOccultingBodyRadius() {
        return this.occultingBodyRadius;
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        FieldVector3D sunDirection = this.sun.getPosition(s.getDate(), s.getFrame()).normalize();
        FieldVector3D<T> position = s.getPosition();
        CalculusFieldElement dotProduct = position.dotProduct(sunDirection);
        if (dotProduct.getReal() >= 0.0) {
            return (T)((CalculusFieldElement)position.getNorm().divide(this.occultingBodyRadius));
        }
        CalculusFieldElement distanceToCylinderAxis = position.subtract(sunDirection.scalarMultiply(dotProduct)).getNorm();
        return (T)((CalculusFieldElement)((CalculusFieldElement)distanceToCylinderAxis.divide(this.occultingBodyRadius)).subtract(1.0));
    }

    @Override
    protected FieldCylindricalShadowEclipseDetector<T> create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> newHandler) {
        return new FieldCylindricalShadowEclipseDetector<T>(this.sun, this.occultingBodyRadius, new FieldEventDetectionSettings<T>(newMaxCheck, newThreshold, newMaxIter), newHandler);
    }
}

