/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.FieldNegateDetector;
import org.orekit.propagation.events.handlers.FieldContinueOnEvent;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.time.FieldAbsoluteDate;

public class FieldBooleanDetector<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldBooleanDetector<T>, T> {
    private final List<FieldEventDetector<T>> detectors;
    private final Operator operator;

    protected FieldBooleanDetector(List<FieldEventDetector<T>> detectors, Operator operator, FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> newHandler) {
        super(new FieldEventDetectionSettings<T>(newMaxCheck, newThreshold, newMaxIter), newHandler);
        this.detectors = detectors;
        this.operator = operator;
    }

    @SafeVarargs
    public static <T extends CalculusFieldElement<T>> FieldBooleanDetector<T> andCombine(FieldEventDetector<T> ... detectors) {
        return FieldBooleanDetector.andCombine(Arrays.asList(detectors));
    }

    public static <T extends CalculusFieldElement<T>> FieldBooleanDetector<T> andCombine(Collection<? extends FieldEventDetector<T>> detectors) {
        return new FieldBooleanDetector<CalculusFieldElement>(new ArrayList<FieldEventDetector<T>>(detectors), Operator.AND, s -> {
            double minInterval = Double.POSITIVE_INFINITY;
            for (FieldEventDetector detector : detectors) {
                minInterval = FastMath.min((double)minInterval, (double)detector.getMaxCheckInterval().currentInterval(s));
            }
            return minInterval;
        }, detectors.stream().map(FieldEventDetector::getThreshold).min(new FieldComparator()).get(), detectors.stream().map(FieldEventDetector::getMaxIterationCount).min(Integer::compareTo).get(), new FieldContinueOnEvent());
    }

    @SafeVarargs
    public static <T extends CalculusFieldElement<T>> FieldBooleanDetector<T> orCombine(FieldEventDetector<T> ... detectors) {
        return FieldBooleanDetector.orCombine(Arrays.asList(detectors));
    }

    public static <T extends CalculusFieldElement<T>> FieldBooleanDetector<T> orCombine(Collection<? extends FieldEventDetector<T>> detectors) {
        return new FieldBooleanDetector<CalculusFieldElement>(new ArrayList<FieldEventDetector<T>>(detectors), Operator.OR, s -> {
            double minInterval = Double.POSITIVE_INFINITY;
            for (FieldEventDetector detector : detectors) {
                minInterval = FastMath.min((double)minInterval, (double)detector.getMaxCheckInterval().currentInterval(s));
            }
            return minInterval;
        }, detectors.stream().map(FieldEventDetector::getThreshold).min(new FieldComparator()).get(), detectors.stream().map(FieldEventDetector::getMaxIterationCount).min(Integer::compareTo).get(), new FieldContinueOnEvent());
    }

    public static <T extends CalculusFieldElement<T>> FieldNegateDetector<T> notCombine(FieldEventDetector<T> detector) {
        return new FieldNegateDetector<T>(detector);
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        Object ret = (CalculusFieldElement)((CalculusFieldElement)s.getDate().getField().getZero()).newInstance(Double.NaN);
        boolean first = true;
        for (FieldEventDetector<T> detector : this.detectors) {
            if (first) {
                ret = detector.g(s);
                first = false;
                continue;
            }
            ret = this.operator.combine(ret, detector.g(s));
        }
        return (T)ret;
    }

    @Override
    protected FieldBooleanDetector<T> create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> newHandler) {
        return new FieldBooleanDetector<T>(this.detectors, this.operator, newMaxCheck, newThreshold, newMaxIter, newHandler);
    }

    @Override
    public void init(FieldSpacecraftState<T> s0, FieldAbsoluteDate<T> t) {
        super.init(s0, t);
        for (FieldEventDetector<T> detector : this.detectors) {
            detector.init(s0, t);
        }
    }

    public List<FieldEventDetector<T>> getDetectors() {
        return new ArrayList<FieldEventDetector<T>>(this.detectors);
    }

    private static class FieldComparator<T extends CalculusFieldElement<T>>
    implements Comparator<T>,
    Serializable {
        private FieldComparator() {
        }

        @Override
        public int compare(T t1, T t2) {
            return Double.compare(t1.getReal(), t2.getReal());
        }
    }

    private static enum Operator {
        AND{

            @Override
            public <T extends CalculusFieldElement<T>> T combine(T g1, T g2) {
                return (T)FastMath.min(g1, g2);
            }
        }
        ,
        OR{

            @Override
            public <T extends CalculusFieldElement<T>> T combine(T g1, T g2) {
                return (T)FastMath.max(g1, g2);
            }
        };


        public abstract <T extends CalculusFieldElement<T>> T combine(T var1, T var2);
    }
}

