/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.CelestialBodyFactory;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnEvent;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldBetaAngleDetector<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldBetaAngleDetector<T>, T> {
    private final T betaAngleThreshold;
    private final FieldPVCoordinatesProvider<T> celestialBodyProvider;
    private final Frame inertialFrame;

    @DefaultDataContext
    public FieldBetaAngleDetector(T betaAngleThreshold) {
        this(betaAngleThreshold.getField(), betaAngleThreshold, CelestialBodyFactory.getSun().toFieldPVCoordinatesProvider(betaAngleThreshold.getField()), FramesFactory.getGCRF());
    }

    public FieldBetaAngleDetector(Field<T> field, T betaAngleThreshold, FieldPVCoordinatesProvider<T> celestialBodyProvider, Frame inertialFrame) {
        this(FieldAdaptableInterval.of(600.0), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(1.0E-6), 100, new FieldStopOnEvent(), (CalculusFieldElement)betaAngleThreshold, (FieldPVCoordinatesProvider<CalculusFieldElement>)celestialBodyProvider, inertialFrame);
    }

    protected FieldBetaAngleDetector(FieldAdaptableInterval<T> maxCheck, T threshold, int maxIter, FieldEventHandler<T> handler, T betaAngleThreshold, FieldPVCoordinatesProvider<T> celestialBodyProvider, Frame inertialFrame) {
        super(new FieldEventDetectionSettings<T>(maxCheck, threshold, maxIter), handler);
        this.betaAngleThreshold = betaAngleThreshold;
        this.celestialBodyProvider = celestialBodyProvider;
        this.inertialFrame = inertialFrame;
    }

    public FieldPVCoordinatesProvider<T> getCelestialBodyProvider() {
        return this.celestialBodyProvider;
    }

    public Frame getInertialFrame() {
        return this.inertialFrame;
    }

    public T getBetaAngleThreshold() {
        return this.betaAngleThreshold;
    }

    public FieldBetaAngleDetector<T> withCelestialProvider(FieldPVCoordinatesProvider<T> newProvider) {
        return new FieldBetaAngleDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), this.getBetaAngleThreshold(), newProvider, this.getInertialFrame());
    }

    public FieldBetaAngleDetector<T> withBetaThreshold(T newBetaAngleThreshold) {
        return new FieldBetaAngleDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), newBetaAngleThreshold, this.getCelestialBodyProvider(), this.getInertialFrame());
    }

    public FieldBetaAngleDetector<T> withInertialFrame(Frame newFrame) {
        return new FieldBetaAngleDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), this.getBetaAngleThreshold(), this.getCelestialBodyProvider(), newFrame);
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        T beta = FieldBetaAngleDetector.calculateBetaAngle(s, this.celestialBodyProvider, this.inertialFrame);
        return (T)((CalculusFieldElement)this.betaAngleThreshold.subtract(beta));
    }

    public static <T extends CalculusFieldElement<T>> T calculateBetaAngle(FieldSpacecraftState<T> state, FieldPVCoordinatesProvider<T> celestialBodyProvider) {
        return FieldBetaAngleDetector.calculateBetaAngle(state, celestialBodyProvider, state.getFrame());
    }

    public static <T extends CalculusFieldElement<T>> T calculateBetaAngle(FieldSpacecraftState<T> state, FieldPVCoordinatesProvider<T> celestialBodyProvider, Frame frame) {
        FieldVector3D<T> celestialP = celestialBodyProvider.getPosition(state.getDate(), frame);
        TimeStampedFieldPVCoordinates<T> pv = state.getPVCoordinates(frame);
        return (T)((CalculusFieldElement)((CalculusFieldElement)FieldVector3D.angle(celestialP, pv.getMomentum()).negate()).add(1.5707963267948966));
    }

    @Override
    protected FieldBetaAngleDetector<T> create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> newHandler) {
        return new FieldBetaAngleDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.getBetaAngleThreshold(), this.getCelestialBodyProvider(), this.getInertialFrame());
    }
}

