/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.orbits.FieldOrbit;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnIncreasing;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldApsideDetector<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldApsideDetector<T>, T> {
    public FieldApsideDetector(T keplerianPeriod) {
        super(new FieldEventDetectionSettings<CalculusFieldElement>(((CalculusFieldElement)keplerianPeriod.divide(3.0)).getReal(), (CalculusFieldElement)keplerianPeriod.multiply(1.0E-13), 100), new FieldStopOnIncreasing());
    }

    public FieldApsideDetector(FieldOrbit<T> orbit) {
        this(orbit.getKeplerianPeriod());
    }

    public FieldApsideDetector(T threshold, FieldOrbit<T> orbit) {
        super(new FieldEventDetectionSettings<T>(((CalculusFieldElement)orbit.getKeplerianPeriod().divide(3.0)).getReal(), threshold, 100), new FieldStopOnIncreasing());
    }

    public FieldApsideDetector(FieldAdaptableInterval<T> maxCheck, T threshold, int maxIter, FieldEventHandler<T> handler) {
        super(new FieldEventDetectionSettings<T>(maxCheck, threshold, maxIter), handler);
    }

    @Override
    protected FieldApsideDetector<T> create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> newHandler) {
        return new FieldApsideDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler);
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        TimeStampedFieldPVCoordinates<T> pv = s.getPVCoordinates();
        return (T)FieldVector3D.dotProduct(pv.getPosition(), pv.getVelocity());
    }
}

