/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.time.FieldAbsoluteDate;

public abstract class FieldAbstractDetector<D extends FieldAbstractDetector<D, T>, T extends CalculusFieldElement<T>>
implements FieldEventDetector<T> {
    public static final double DEFAULT_MAXCHECK = 600.0;
    public static final double DEFAULT_THRESHOLD = 1.0E-6;
    public static final int DEFAULT_MAX_ITER = 100;
    private final FieldEventDetectionSettings<T> eventDetectionSettings;
    private final FieldEventHandler<T> handler;
    private boolean forward;

    @Deprecated
    protected FieldAbstractDetector(FieldAdaptableInterval<T> maxCheck, T threshold, int maxIter, FieldEventHandler<T> handler) {
        this(new FieldEventDetectionSettings<T>(maxCheck, threshold, maxIter), handler);
    }

    protected FieldAbstractDetector(FieldEventDetectionSettings<T> detectionSettings, FieldEventHandler<T> handler) {
        this.checkStrictlyPositive(detectionSettings.getThreshold().getReal());
        this.eventDetectionSettings = detectionSettings;
        this.handler = handler;
        this.forward = true;
    }

    private void checkStrictlyPositive(double value) throws OrekitException {
        if (value <= 0.0) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_STRICTLY_POSITIVE, value);
        }
    }

    @Override
    public void init(FieldSpacecraftState<T> s0, FieldAbsoluteDate<T> t) {
        this.forward = t.durationFrom(s0.getDate()).getReal() >= 0.0;
        this.getHandler().init(s0, t, this);
    }

    @Override
    public FieldEventDetectionSettings<T> getDetectionSettings() {
        return this.eventDetectionSettings;
    }

    @Override
    public FieldAdaptableInterval<T> getMaxCheckInterval() {
        return this.getDetectionSettings().getMaxCheckInterval();
    }

    @Override
    public int getMaxIterationCount() {
        return this.getDetectionSettings().getMaxIterationCount();
    }

    @Override
    public T getThreshold() {
        return this.getDetectionSettings().getThreshold();
    }

    public D withMaxCheck(double newMaxCheck) {
        return this.withMaxCheck(FieldAdaptableInterval.of(newMaxCheck));
    }

    public D withMaxCheck(FieldAdaptableInterval<T> newMaxCheck) {
        return this.create(new FieldEventDetectionSettings<T>(newMaxCheck, this.getThreshold(), this.getMaxIterationCount()), this.getHandler());
    }

    public D withMaxIter(int newMaxIter) {
        return this.create(new FieldEventDetectionSettings<T>(this.getMaxCheckInterval(), this.getThreshold(), newMaxIter), this.getHandler());
    }

    public D withThreshold(T newThreshold) {
        return this.create(new FieldEventDetectionSettings<T>(this.getMaxCheckInterval(), newThreshold, this.getMaxIterationCount()), this.getHandler());
    }

    public D withDetectionSettings(FieldEventDetectionSettings<T> newSettings) {
        return this.create(newSettings, this.getHandler());
    }

    public D withHandler(FieldEventHandler<T> newHandler) {
        return this.create(this.getDetectionSettings(), newHandler);
    }

    @Override
    public FieldEventHandler<T> getHandler() {
        return this.handler;
    }

    @Deprecated
    protected abstract D create(FieldAdaptableInterval<T> var1, T var2, int var3, FieldEventHandler<T> var4);

    protected D create(FieldEventDetectionSettings<T> detectionSettings, FieldEventHandler<T> newHandler) {
        return this.create(detectionSettings.getMaxCheckInterval(), detectionSettings.getThreshold(), detectionSettings.getMaxIterationCount(), newHandler);
    }

    public boolean isForward() {
        return this.forward;
    }
}

