/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public class ExtremumApproachDetector
extends AbstractDetector<ExtremumApproachDetector> {
    private final PVCoordinatesProvider secondaryPVProvider;

    public ExtremumApproachDetector(PVCoordinatesProvider secondaryPVProvider) {
        this(EventDetectionSettings.getDefaultEventDetectionSettings(), new StopOnIncreasing(), secondaryPVProvider);
    }

    protected ExtremumApproachDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, PVCoordinatesProvider secondaryPVProvider) {
        this(new EventDetectionSettings(maxCheck, threshold, maxIter), handler, secondaryPVProvider);
    }

    protected ExtremumApproachDetector(EventDetectionSettings detectionSettings, EventHandler handler, PVCoordinatesProvider secondaryPVProvider) {
        super(detectionSettings, handler);
        this.secondaryPVProvider = secondaryPVProvider;
    }

    @Override
    public double g(SpacecraftState s) {
        PVCoordinates deltaPV = this.computeDeltaPV(s);
        return Vector3D.dotProduct((Vector3D)deltaPV.getPosition(), (Vector3D)deltaPV.getVelocity());
    }

    @Deprecated
    public PVCoordinates computeDeltaPV(SpacecraftState s) {
        Vector3D primaryPos = s.getPosition();
        Vector3D primaryVel = s.getPVCoordinates().getVelocity();
        TimeStampedPVCoordinates secondaryPV = this.secondaryPVProvider.getPVCoordinates(s.getDate(), s.getFrame());
        Vector3D secondaryPos = secondaryPV.getPosition();
        Vector3D secondaryVel = secondaryPV.getVelocity();
        Vector3D relativePos = secondaryPos.subtract((Vector)primaryPos);
        Vector3D relativeVel = secondaryVel.subtract((Vector)primaryVel);
        return new PVCoordinates(relativePos, relativeVel);
    }

    @Override
    protected ExtremumApproachDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new ExtremumApproachDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.secondaryPVProvider);
    }

    public PVCoordinatesProvider getSecondaryPVProvider() {
        return this.secondaryPVProvider;
    }
}

