/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.ode.events.Action;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;

public class EventsLogger {
    private final List<LoggedEvent> log = new ArrayList<LoggedEvent>();

    public <T extends EventDetector> EventDetector monitorDetector(T monitoredDetector) {
        return new LoggingWrapper(monitoredDetector);
    }

    public void clearLoggedEvents() {
        this.log.clear();
    }

    public List<LoggedEvent> getLoggedEvents() {
        return new ArrayList<LoggedEvent>(this.log);
    }

    private class LoggingWrapper
    extends AbstractDetector<LoggingWrapper> {
        private final EventDetector detector;

        LoggingWrapper(EventDetector detector) {
            this(detector.getDetectionSettings(), null, detector);
        }

        private LoggingWrapper(EventDetectionSettings detectionSettings, EventHandler handler, EventDetector detector) {
            super(detectionSettings, handler);
            this.detector = detector;
        }

        @Override
        protected LoggingWrapper create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
            return new LoggingWrapper(new EventDetectionSettings(newMaxCheck, newThreshold, newMaxIter), newHandler, this.detector);
        }

        public void logEvent(SpacecraftState state, boolean increasing) {
            EventsLogger.this.log.add(new LoggedEvent(this.detector, state, increasing));
        }

        @Override
        public void init(SpacecraftState s0, AbsoluteDate t) {
            super.init(s0, t);
            this.detector.init(s0, t);
        }

        @Override
        public double g(SpacecraftState s) {
            return this.detector.g(s);
        }

        @Override
        public void finish(SpacecraftState state) {
            this.detector.finish(state);
        }

        @Override
        public EventHandler getHandler() {
            final EventHandler handler = this.detector.getHandler();
            return new EventHandler(){

                @Override
                public Action eventOccurred(SpacecraftState s, EventDetector d, boolean increasing) {
                    LoggingWrapper.this.logEvent(s, increasing);
                    return handler.eventOccurred(s, LoggingWrapper.this.detector, increasing);
                }

                @Override
                public SpacecraftState resetState(EventDetector d, SpacecraftState oldState) {
                    return handler.resetState(LoggingWrapper.this.detector, oldState);
                }
            };
        }
    }

    public static class LoggedEvent
    implements TimeStamped {
        private final EventDetector detector;
        private final SpacecraftState state;
        private final boolean increasing;

        private LoggedEvent(EventDetector detector, SpacecraftState state, boolean increasing) {
            this.detector = detector;
            this.state = state;
            this.increasing = increasing;
        }

        public EventDetector getEventDetector() {
            return this.detector;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.state.getDate();
        }

        public SpacecraftState getState() {
            return this.state;
        }

        public boolean isIncreasing() {
            return this.increasing;
        }
    }
}

