/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.util.function.DoubleFunction;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.BracketedUnivariateSolver;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.ode.events.Action;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;

public class EventState<T extends EventDetector> {
    private T detector;
    private EventHandler handler;
    private AbsoluteDate lastT;
    private double lastG;
    private AbsoluteDate t0;
    private double g0;
    private boolean g0Positive;
    private boolean pendingEvent;
    private AbsoluteDate pendingEventTime;
    private AbsoluteDate stopTime;
    private AbsoluteDate afterEvent;
    private double afterG;
    private AbsoluteDate earliestTimeConsidered;
    private boolean forward;
    private boolean increasing;

    public EventState(T detector) {
        this.detector = detector;
        this.handler = detector.getHandler();
        this.lastT = AbsoluteDate.PAST_INFINITY;
        this.lastG = Double.NaN;
        this.t0 = null;
        this.g0 = Double.NaN;
        this.g0Positive = true;
        this.pendingEvent = false;
        this.pendingEventTime = null;
        this.stopTime = null;
        this.increasing = true;
        this.earliestTimeConsidered = null;
        this.afterEvent = null;
        this.afterG = Double.NaN;
    }

    public T getEventDetector() {
        return this.detector;
    }

    public void init(SpacecraftState s0, AbsoluteDate t) {
        this.detector.init(s0, t);
        this.lastT = AbsoluteDate.PAST_INFINITY;
        this.lastG = Double.NaN;
    }

    private double g(SpacecraftState s) {
        if (!s.getDate().equals(this.lastT)) {
            this.lastG = this.detector.g(s);
            this.lastT = s.getDate();
        }
        return this.lastG;
    }

    public void reinitializeBegin(OrekitStepInterpolator interpolator) {
        this.forward = interpolator.isForward();
        SpacecraftState s0 = interpolator.getPreviousState();
        this.t0 = s0.getDate();
        this.g0 = this.g(s0);
        while (this.g0 == 0.0) {
            double dt = (this.forward ? 0.5 : -0.5) * this.detector.getThreshold();
            AbsoluteDate startDate = this.t0.shiftedBy(dt);
            if (this.t0.equals(startDate)) {
                startDate = this.nextAfter(startDate);
            }
            this.t0 = startDate;
            this.g0 = this.g(interpolator.getInterpolatedState(this.t0));
        }
        this.increasing = this.g0Positive = this.g0 > 0.0;
    }

    public boolean evaluateStep(OrekitStepInterpolator interpolator) throws MathRuntimeException {
        this.forward = interpolator.isForward();
        SpacecraftState s0 = interpolator.getPreviousState();
        SpacecraftState s1 = interpolator.getCurrentState();
        AbsoluteDate t1 = s1.getDate();
        double dt = t1.durationFrom(this.t0);
        if (FastMath.abs((double)dt) < this.detector.getThreshold()) {
            this.pendingEvent = false;
            this.pendingEventTime = null;
            return false;
        }
        AbsoluteDate ta = this.t0;
        double ga = this.g0;
        SpacecraftState sb = this.nextCheck(s0, s1, interpolator);
        while (sb != null) {
            AbsoluteDate tb = sb.getDate();
            double gb = this.g(sb);
            if (gb == 0.0 || this.g0Positive ^ gb > 0.0) {
                if (this.findRoot(interpolator, ta, ga, tb, gb)) {
                    return true;
                }
            } else {
                ta = tb;
                ga = gb;
            }
            sb = this.nextCheck(sb, s1, interpolator);
        }
        this.pendingEvent = false;
        this.pendingEventTime = null;
        return false;
    }

    private SpacecraftState nextCheck(SpacecraftState done, SpacecraftState target, OrekitStepInterpolator interpolator) {
        if (done == target) {
            return null;
        }
        double dt = target.getDate().durationFrom(done.getDate());
        double maxCheck = this.detector.getMaxCheckInterval().currentInterval(done);
        int n = FastMath.max((int)1, (int)((int)FastMath.ceil((double)(FastMath.abs((double)dt) / maxCheck))));
        return n == 1 ? target : interpolator.getInterpolatedState(done.getDate().shiftedBy(dt / (double)n));
    }

    private boolean findRoot(OrekitStepInterpolator interpolator, AbsoluteDate ta, double ga, AbsoluteDate tb, double gb) {
        double newGa;
        this.check(ga == 0.0 || gb == 0.0 || ga > 0.0 && gb < 0.0 || ga < 0.0 && gb > 0.0);
        double convergence = this.detector.getThreshold();
        int maxIterationCount = this.detector.getMaxIterationCount();
        BracketingNthOrderBrentSolver solver = new BracketingNthOrderBrentSolver(0.0, convergence, 0.0, 5);
        AbsoluteDate loopT = ta;
        double loopG = ga;
        AbsoluteDate beforeRootT = null;
        double beforeRootG = Double.NaN;
        AbsoluteDate afterRootT = ta;
        double afterRootG = 0.0;
        if (ta.equals(tb)) {
            beforeRootT = ta;
            beforeRootG = ga;
            afterRootT = this.shiftedBy(beforeRootT, convergence);
            afterRootG = this.g(interpolator.getInterpolatedState(afterRootT));
        } else if (ga != 0.0 && gb == 0.0) {
            beforeRootT = tb;
            beforeRootG = gb;
            afterRootT = this.shiftedBy(beforeRootT, convergence);
            afterRootG = this.g(interpolator.getInterpolatedState(afterRootT));
        } else if (ga != 0.0 && ga > 0.0 != (newGa = this.g(interpolator.getInterpolatedState(ta))) > 0.0) {
            AbsoluteDate nextT = this.minTime(this.shiftedBy(ta, convergence), tb);
            double nextG = this.g(interpolator.getInterpolatedState(nextT));
            if (nextG > 0.0 == this.g0Positive) {
                loopT = nextT;
                loopG = nextG;
            } else {
                beforeRootT = ta;
                beforeRootG = newGa;
                afterRootT = nextT;
                afterRootG = nextG;
            }
        }
        while ((afterRootG == 0.0 || afterRootG > 0.0 == this.g0Positive) && this.strictlyAfter(afterRootT, tb)) {
            if (loopG == 0.0) {
                beforeRootT = loopT;
                beforeRootG = loopG;
                afterRootT = this.minTime(this.shiftedBy(beforeRootT, convergence), tb);
                afterRootG = this.g(interpolator.getInterpolatedState(afterRootT));
            } else {
                BracketedUnivariateSolver.Interval interval;
                AbsoluteDate fT0 = loopT;
                double tbDouble = tb.durationFrom(fT0);
                double middle = 0.5 * tbDouble;
                DoubleFunction<AbsoluteDate> date = dt -> {
                    if (this.forward == dt <= middle) {
                        return fT0.shiftedBy(dt);
                    }
                    return tb.shiftedBy(dt - tbDouble);
                };
                UnivariateFunction f = dt -> this.g(interpolator.getInterpolatedState((AbsoluteDate)date.apply(dt)));
                if (this.forward) {
                    try {
                        interval = solver.solveInterval(maxIterationCount, f, 0.0, tbDouble);
                        beforeRootT = date.apply(interval.getLeftAbscissa());
                        beforeRootG = interval.getLeftValue();
                        afterRootT = date.apply(interval.getRightAbscissa());
                        afterRootG = interval.getRightValue();
                    }
                    catch (RuntimeException e) {
                        throw new OrekitException(e, OrekitMessages.FIND_ROOT, this.detector, loopT, loopG, tb, gb, this.lastT, this.lastG);
                    }
                }
                try {
                    interval = solver.solveInterval(maxIterationCount, f, tbDouble, 0.0);
                    beforeRootT = date.apply(interval.getRightAbscissa());
                    beforeRootG = interval.getRightValue();
                    afterRootT = date.apply(interval.getLeftAbscissa());
                    afterRootG = interval.getLeftValue();
                }
                catch (RuntimeException e) {
                    throw new OrekitException(e, OrekitMessages.FIND_ROOT, this.detector, tb, gb, loopT, loopG, this.lastT, this.lastG);
                }
            }
            if (beforeRootT.equals(afterRootT)) {
                afterRootT = this.nextAfter(afterRootT);
                afterRootG = this.g(interpolator.getInterpolatedState(afterRootT));
            }
            this.check(this.forward && afterRootT.compareTo(beforeRootT) > 0 || !this.forward && afterRootT.compareTo(beforeRootT) < 0);
            loopT = afterRootT;
            loopG = afterRootG;
        }
        if (afterRootG == 0.0 || afterRootG > 0.0 == this.g0Positive) {
            return false;
        }
        this.check(beforeRootT != null && !Double.isNaN(beforeRootG));
        this.increasing = !this.g0Positive;
        this.pendingEventTime = beforeRootT;
        this.stopTime = beforeRootG == 0.0 ? beforeRootT : afterRootT;
        this.pendingEvent = true;
        this.afterEvent = afterRootT;
        this.afterG = afterRootG;
        this.check(this.afterG > 0.0 == this.increasing);
        this.check(this.increasing == gb >= ga);
        return true;
    }

    private AbsoluteDate nextAfter(AbsoluteDate t) {
        return t.shiftedBy(this.forward ? Precision.EPSILON : -Precision.EPSILON);
    }

    public AbsoluteDate getEventDate() {
        return this.pendingEventTime;
    }

    public boolean tryAdvance(SpacecraftState state, OrekitStepInterpolator interpolator) {
        boolean meFirst;
        AbsoluteDate t = state.getDate();
        this.check(!this.pendingEvent || !this.strictlyAfter(this.pendingEventTime, t));
        if (this.strictlyAfter(t, this.earliestTimeConsidered)) {
            meFirst = false;
        } else {
            boolean positive;
            double g = this.g(state);
            boolean bl = positive = g > 0.0;
            if (positive == this.g0Positive) {
                this.g0 = g;
                meFirst = false;
            } else {
                AbsoluteDate oldPendingEventTime = this.pendingEventTime;
                boolean foundRoot = this.findRoot(interpolator, this.t0, this.g0, t, g);
                boolean bl2 = meFirst = foundRoot && !this.pendingEventTime.equals(oldPendingEventTime);
            }
        }
        if (!meFirst) {
            this.t0 = t;
        }
        return meFirst;
    }

    public EventOccurrence doEvent(SpacecraftState state) {
        this.check(this.pendingEvent);
        this.check(state.getDate().equals(this.pendingEventTime));
        Action action = this.handler.eventOccurred(state, (EventDetector)this.detector, this.increasing == this.forward);
        SpacecraftState newState = action == Action.RESET_STATE ? this.handler.resetState((EventDetector)this.detector, state) : state;
        this.pendingEvent = false;
        this.pendingEventTime = null;
        this.earliestTimeConsidered = this.afterEvent;
        this.t0 = this.afterEvent;
        this.g0 = this.afterG;
        this.g0Positive = this.increasing;
        this.check(this.g0 == 0.0 || this.g0Positive == this.g0 > 0.0);
        return new EventOccurrence(action, newState, this.stopTime);
    }

    private AbsoluteDate shiftedBy(AbsoluteDate t, double delta) {
        if (this.forward) {
            AbsoluteDate ret = t.shiftedBy(delta);
            if (ret.durationFrom(t) > delta) {
                return ret.shiftedBy(-Precision.EPSILON);
            }
            return ret;
        }
        AbsoluteDate ret = t.shiftedBy(-delta);
        if (t.durationFrom(ret) > delta) {
            return ret.shiftedBy(Precision.EPSILON);
        }
        return ret;
    }

    private AbsoluteDate minTime(AbsoluteDate a, AbsoluteDate b) {
        return this.forward ^ a.compareTo(b) > 0 ? a : b;
    }

    private boolean strictlyAfter(AbsoluteDate t1, AbsoluteDate t2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        return this.forward ? t1.compareTo(t2) < 0 : t2.compareTo(t1) < 0;
    }

    private void check(boolean condition) throws MathRuntimeException {
        if (!condition) {
            throw new OrekitInternalError(null);
        }
    }

    public void finish(SpacecraftState state) {
        this.detector.finish(state);
    }

    public static class EventOccurrence {
        private final Action action;
        private final SpacecraftState newState;
        private final AbsoluteDate stopDate;

        EventOccurrence(Action action, SpacecraftState newState, AbsoluteDate stopDate) {
            this.action = action;
            this.newState = newState;
            this.stopDate = stopDate;
        }

        public Action getAction() {
            return this.action;
        }

        public SpacecraftState getNewState() {
            return this.newState;
        }

        public AbsoluteDate getStopDate() {
            return this.stopDate;
        }
    }
}

