/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.ode.events.Action;
import org.hipparchus.util.FastMath;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;

public class EventShifter
extends AbstractDetector<EventShifter> {
    private final EventDetector detector;
    private final boolean useShiftedStates;
    private final double increasingOffset;
    private final double decreasingOffset;

    public EventShifter(EventDetector detector, boolean useShiftedStates, double increasingTimeShift, double decreasingTimeShift) {
        this(detector.getMaxCheckInterval(), detector.getThreshold(), detector.getMaxIterationCount(), new LocalHandler(), detector, useShiftedStates, increasingTimeShift, decreasingTimeShift);
    }

    protected EventShifter(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, EventDetector detector, boolean useShiftedStates, double increasingTimeShift, double decreasingTimeShift) {
        super(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
        this.detector = detector;
        this.useShiftedStates = useShiftedStates;
        this.increasingOffset = -increasingTimeShift;
        this.decreasingOffset = -decreasingTimeShift;
    }

    @Override
    protected EventShifter create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new EventShifter(newMaxCheck, newThreshold, newMaxIter, newHandler, this.detector, this.useShiftedStates, -this.increasingOffset, -this.decreasingOffset);
    }

    public EventDetector getDetector() {
        return this.detector;
    }

    public double getIncreasingTimeShift() {
        return -this.increasingOffset;
    }

    public double getDecreasingTimeShift() {
        return -this.decreasingOffset;
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        super.init(s0, t);
        this.detector.init(s0, t);
    }

    @Override
    public double g(SpacecraftState s) {
        double incShiftedG = this.detector.g(s.shiftedBy(this.increasingOffset));
        double decShiftedG = this.detector.g(s.shiftedBy(this.decreasingOffset));
        return this.increasingOffset >= this.decreasingOffset ? FastMath.max((double)incShiftedG, (double)decShiftedG) : FastMath.min((double)incShiftedG, (double)decShiftedG);
    }

    private static class LocalHandler
    implements EventHandler {
        private SpacecraftState shiftedState;

        private LocalHandler() {
        }

        @Override
        public Action eventOccurred(SpacecraftState s, EventDetector detector, boolean increasing) {
            EventShifter shifter = (EventShifter)detector;
            if (shifter.useShiftedStates) {
                this.shiftedState = s;
            } else {
                double offset = increasing ? shifter.increasingOffset : shifter.decreasingOffset;
                this.shiftedState = s.shiftedBy(offset);
            }
            return shifter.detector.getHandler().eventOccurred(this.shiftedState, shifter.detector, increasing);
        }

        @Override
        public SpacecraftState resetState(EventDetector detector, SpacecraftState oldState) {
            EventShifter shifter = (EventShifter)detector;
            return shifter.detector.getHandler().resetState(shifter.detector, this.shiftedState);
        }
    }
}

