/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.util.FastMath;
import org.orekit.propagation.events.DateDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldDateDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.FieldResetDerivativesOnEvent;
import org.orekit.propagation.events.handlers.ResetDerivativesOnEvent;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeStamped;
import org.orekit.time.TimeStamped;
import org.orekit.utils.ParameterDriver;

public interface EventDetectorsProvider {
    public static final double DATATION_ACCURACY = 1.0E-10;

    public Stream<EventDetector> getEventDetectors();

    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventDetectors(Field<T> var1);

    default public Stream<EventDetector> getEventDetectors(List<ParameterDriver> parameterDrivers) {
        ArrayList<AbsoluteDate> transitionDates = new ArrayList<AbsoluteDate>();
        for (ParameterDriver driver : parameterDrivers) {
            for (AbsoluteDate date : driver.getTransitionDates()) {
                transitionDates.add(date);
            }
        }
        if (transitionDates.size() == 0) {
            return Stream.empty();
        }
        transitionDates.sort(null);
        double shortestDuration = 600.0;
        for (int i = 1; i < transitionDates.size(); ++i) {
            shortestDuration = FastMath.min((double)shortestDuration, (double)((TimeStamped)transitionDates.get(i)).durationFrom((TimeStamped)transitionDates.get(i - 1)));
        }
        DateDetector datesDetector = (DateDetector)((DateDetector)((DateDetector)new DateDetector(transitionDates.toArray(new TimeStamped[0])).withMaxCheck(0.5 * shortestDuration)).withMinGap(0.5 * shortestDuration).withThreshold(1.0E-10)).withHandler(new ResetDerivativesOnEvent());
        return Stream.of(datesDetector);
    }

    default public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventDetectors(Field<T> field, List<ParameterDriver> parameterDrivers) {
        ArrayList<AbsoluteDate> transitionDates = new ArrayList<AbsoluteDate>();
        for (ParameterDriver driver : parameterDrivers) {
            for (AbsoluteDate date : driver.getTransitionDates()) {
                transitionDates.add(date);
            }
        }
        if (transitionDates.size() == 0) {
            return Stream.empty();
        }
        transitionDates.sort(null);
        double shortestDuration = 600.0;
        for (int i = 1; i < transitionDates.size(); ++i) {
            shortestDuration = FastMath.min((double)shortestDuration, (double)((AbsoluteDate)transitionDates.get(i)).durationFrom((AbsoluteDate)transitionDates.get(i - 1)));
        }
        FieldDateDetector datesDetector = (FieldDateDetector)((FieldDateDetector)((FieldDateDetector)new FieldDateDetector<T>(field, (FieldTimeStamped[])Array.newInstance(FieldTimeStamped.class, 0)).withMaxCheck(0.5 * shortestDuration)).withMinGap(0.5 * shortestDuration).withThreshold((CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(1.0E-10))).withHandler(new FieldResetDerivativesOnEvent());
        for (int i = 0; i < transitionDates.size(); ++i) {
            datesDetector.addEventDate(new FieldAbsoluteDate<T>(field, (AbsoluteDate)transitionDates.get(i)));
        }
        return Stream.of(datesDetector);
    }
}

