/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.orekit.propagation.events.AdaptableInterval;

public class EventDetectionSettings {
    public static final double DEFAULT_MAXCHECK = 600.0;
    public static final double DEFAULT_THRESHOLD = 1.0E-6;
    public static final int DEFAULT_MAX_ITER = 100;
    private final AdaptableInterval maxCheckInterval;
    private final double threshold;
    private final int maxIterationCount;

    public EventDetectionSettings(AdaptableInterval maxCheckInterval, double threshold, int maxIterationCount) {
        this.maxCheckInterval = maxCheckInterval;
        this.maxIterationCount = maxIterationCount;
        this.threshold = threshold;
    }

    public EventDetectionSettings(double maxCheck, double threshold, int maxIterationCount) {
        this(AdaptableInterval.of(maxCheck), threshold, maxIterationCount);
    }

    public AdaptableInterval getMaxCheckInterval() {
        return this.maxCheckInterval;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public int getMaxIterationCount() {
        return this.maxIterationCount;
    }

    public static EventDetectionSettings getDefaultEventDetectionSettings() {
        return new EventDetectionSettings(600.0, 1.0E-6, 100);
    }
}

