/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.analysis.differentiation.UnivariateDerivative1;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.frames.Frame;
import org.orekit.frames.KinematicTransform;
import org.orekit.frames.TopocentricFrame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;
import org.orekit.utils.TimeStampedPVCoordinates;

public class ElevationExtremumDetector
extends AbstractDetector<ElevationExtremumDetector> {
    private final TopocentricFrame topo;

    public ElevationExtremumDetector(TopocentricFrame topo) {
        this(600.0, 1.0E-6, topo);
    }

    public ElevationExtremumDetector(double maxCheck, double threshold, TopocentricFrame topo) {
        this(AdaptableInterval.of(maxCheck), threshold, 100, new StopOnIncreasing(), topo);
    }

    protected ElevationExtremumDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, TopocentricFrame topo) {
        super(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
        this.topo = topo;
    }

    @Override
    protected ElevationExtremumDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new ElevationExtremumDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.topo);
    }

    public TopocentricFrame getTopocentricFrame() {
        return this.topo;
    }

    public double getElevation(SpacecraftState s) {
        return this.topo.getElevation(s.getPosition(), s.getFrame(), s.getDate());
    }

    @Override
    public double g(SpacecraftState s) {
        KinematicTransform inertToTopo = s.getFrame().getKinematicTransformTo((Frame)this.topo, s.getDate());
        TimeStampedPVCoordinates pvTopo = inertToTopo.transformOnlyPV(s.getPVCoordinates());
        FieldVector3D<UnivariateDerivative1> pvDS = pvTopo.toUnivariateDerivative1Vector();
        UnivariateDerivative1 elevation = (UnivariateDerivative1)((UnivariateDerivative1)pvDS.getZ()).divide((UnivariateDerivative1)pvDS.getNorm()).asin();
        return elevation.getDerivative(1);
    }
}

