/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.orekit.frames.TopocentricFrame;
import org.orekit.models.AtmosphericRefractionModel;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnDecreasing;
import org.orekit.utils.ElevationMask;
import org.orekit.utils.TrackingCoordinates;

public class ElevationDetector
extends AbstractDetector<ElevationDetector> {
    private final ElevationMask elevationMask;
    private final double minElevation;
    private final AtmosphericRefractionModel refractionModel;
    private final TopocentricFrame topo;

    public ElevationDetector(TopocentricFrame topo) {
        this(600.0, 1.0E-6, topo);
    }

    public ElevationDetector(double maxCheck, double threshold, TopocentricFrame topo) {
        this(AdaptableInterval.of(maxCheck), threshold, topo);
    }

    public ElevationDetector(AdaptableInterval maxCheck, double threshold, TopocentricFrame topo) {
        this(maxCheck, threshold, 100, new StopOnDecreasing(), 0.0, null, null, topo);
    }

    protected ElevationDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, double minElevation, ElevationMask mask, AtmosphericRefractionModel refractionModel, TopocentricFrame topo) {
        super(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
        this.minElevation = minElevation;
        this.elevationMask = mask;
        this.refractionModel = refractionModel;
        this.topo = topo;
    }

    @Override
    protected ElevationDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new ElevationDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.minElevation, this.elevationMask, this.refractionModel, this.topo);
    }

    public ElevationMask getElevationMask() {
        return this.elevationMask;
    }

    public double getMinElevation() {
        return this.minElevation;
    }

    public AtmosphericRefractionModel getRefractionModel() {
        return this.refractionModel;
    }

    public TopocentricFrame getTopocentricFrame() {
        return this.topo;
    }

    @Override
    public double g(SpacecraftState s) {
        TrackingCoordinates tc = this.topo.getTrackingCoordinates(s.getPosition(), s.getFrame(), s.getDate());
        double calculatedElevation = this.refractionModel != null ? tc.getElevation() + this.refractionModel.getRefraction(tc.getElevation()) : tc.getElevation();
        if (this.elevationMask != null) {
            return calculatedElevation - this.elevationMask.getElevation(tc.getAzimuth());
        }
        return calculatedElevation - this.minElevation;
    }

    public ElevationDetector withConstantElevation(double newMinElevation) {
        return new ElevationDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), newMinElevation, null, this.refractionModel, this.topo);
    }

    public ElevationDetector withElevationMask(ElevationMask newElevationMask) {
        return new ElevationDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), Double.NaN, newElevationMask, this.refractionModel, this.topo);
    }

    public ElevationDetector withRefraction(AtmosphericRefractionModel newRefractionModel) {
        return new ElevationDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), this.minElevation, this.elevationMask, newRefractionModel, this.topo);
    }
}

