/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.OccultationEngine;

public class EclipseDetector
extends AbstractDetector<EclipseDetector> {
    private final OccultationEngine occultationEngine;
    private final boolean totalEclipse;
    private final double margin;

    public EclipseDetector(ExtendedPVCoordinatesProvider occulted, double occultedRadius, OneAxisEllipsoid occulting) {
        this(new OccultationEngine(occulted, occultedRadius, occulting));
    }

    public EclipseDetector(OccultationEngine occultationEngine) {
        this(new EventDetectionSettings(AdaptableInterval.of(600.0), 1.0E-6, 100), new StopOnIncreasing(), occultationEngine, 0.0, true);
    }

    @Deprecated
    protected EclipseDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, OccultationEngine occultationEngine, double margin, boolean totalEclipse) {
        this(new EventDetectionSettings(maxCheck, threshold, maxIter), handler, occultationEngine, margin, totalEclipse);
    }

    protected EclipseDetector(EventDetectionSettings detectionSettings, EventHandler handler, OccultationEngine occultationEngine, double margin, boolean totalEclipse) {
        super(detectionSettings, handler);
        this.occultationEngine = occultationEngine;
        this.margin = margin;
        this.totalEclipse = totalEclipse;
    }

    @Override
    protected EclipseDetector create(AdaptableInterval newMaxCheck, double newThreshold, int nawMaxIter, EventHandler newHandler) {
        return new EclipseDetector(newMaxCheck, newThreshold, nawMaxIter, newHandler, this.occultationEngine, this.margin, this.totalEclipse);
    }

    public EclipseDetector withUmbra() {
        return new EclipseDetector(this.getDetectionSettings(), this.getHandler(), this.occultationEngine, this.margin, true);
    }

    public EclipseDetector withPenumbra() {
        return new EclipseDetector(this.getDetectionSettings(), this.getHandler(), this.occultationEngine, this.margin, false);
    }

    public EclipseDetector withMargin(double newMargin) {
        return new EclipseDetector(this.getDetectionSettings(), this.getHandler(), this.occultationEngine, newMargin, this.totalEclipse);
    }

    public double getMargin() {
        return this.margin;
    }

    public OccultationEngine getOccultationEngine() {
        return this.occultationEngine;
    }

    public boolean getTotalEclipse() {
        return this.totalEclipse;
    }

    @Override
    public double g(SpacecraftState s) {
        OccultationEngine.OccultationAngles angles = this.occultationEngine.angles(s);
        return this.totalEclipse ? angles.getSeparation() - angles.getLimbRadius() + angles.getOccultedApparentRadius() + this.margin : angles.getSeparation() - angles.getLimbRadius() - angles.getOccultedApparentRadius() + this.margin;
    }
}

