/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnEvent;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;

public class DateDetector
extends AbstractDetector<DateDetector>
implements TimeStamped {
    public static final double DEFAULT_MAX_CHECK = 1.0E10;
    public static final double DEFAULT_MIN_GAP = 1.0;
    public static final double DEFAULT_THRESHOLD = 1.0E-13;
    private final double minGap;
    private AbsoluteDate gDate = null;
    private final ArrayList<EventDate> eventDateList;
    private int currentIndex = -1;

    public DateDetector(TimeStamped ... dates) {
        this(new EventDetectionSettings(AdaptableInterval.of(1.0E10), 1.0E-13, 100), new StopOnEvent(), 1.0, dates);
    }

    @Deprecated
    protected DateDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, double minGap, TimeStamped ... dates) {
        this(new EventDetectionSettings(maxCheck, threshold, maxIter), handler, minGap, dates);
    }

    protected DateDetector(EventDetectionSettings detectionSettings, EventHandler handler, double minGap, TimeStamped ... dates) {
        super(detectionSettings, handler);
        this.eventDateList = new ArrayList(dates.length);
        for (TimeStamped ts : dates) {
            this.addEventDate(ts.getDate());
        }
        this.minGap = minGap;
    }

    public DateDetector withMinGap(double newMinGap) {
        return new DateDetector(this.getDetectionSettings(), this.getHandler(), newMinGap, (TimeStamped[])this.eventDateList.toArray(new EventDate[this.eventDateList.size()]));
    }

    @Override
    protected DateDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new DateDetector(new EventDetectionSettings(newMaxCheck, newThreshold, newMaxIter), newHandler, this.minGap, (TimeStamped[])this.eventDateList.toArray(new EventDate[this.eventDateList.size()]));
    }

    public List<TimeStamped> getDates() {
        return Collections.unmodifiableList(this.eventDateList);
    }

    @Override
    public double g(SpacecraftState s) {
        this.gDate = s.getDate();
        if (this.currentIndex < 0) {
            return -1.0;
        }
        EventDate event = this.getClosest(this.gDate);
        return event.isgIncrease() ? this.gDate.durationFrom(event.getDate()) : event.getDate().durationFrom(this.gDate);
    }

    @Override
    public AbsoluteDate getDate() {
        return this.currentIndex < 0 ? null : this.eventDateList.get(this.currentIndex).getDate();
    }

    public void addEventDate(AbsoluteDate target) throws IllegalArgumentException {
        if (this.currentIndex < 0) {
            boolean increasing = this.gDate == null ? true : target.durationFrom(this.gDate) > 0.0;
            this.currentIndex = 0;
            this.eventDateList.add(new EventDate(target, increasing));
        } else {
            int lastIndex = this.eventDateList.size() - 1;
            AbsoluteDate firstDate = this.eventDateList.get(0).getDate();
            AbsoluteDate lastDate = this.eventDateList.get(lastIndex).getDate();
            if (firstDate.durationFrom(target) > this.minGap) {
                boolean increasing = !this.eventDateList.get(0).isgIncrease();
                this.eventDateList.add(0, new EventDate(target, increasing));
                ++this.currentIndex;
            } else if (target.durationFrom(lastDate) > this.minGap) {
                boolean increasing = !this.eventDateList.get(lastIndex).isgIncrease();
                this.eventDateList.add(new EventDate(target, increasing));
            } else {
                throw new OrekitIllegalArgumentException(OrekitMessages.EVENT_DATE_TOO_CLOSE, target, firstDate, lastDate, this.minGap, firstDate.durationFrom(target), target.durationFrom(lastDate));
            }
        }
    }

    private EventDate getClosest(AbsoluteDate target) {
        block5: {
            double dt;
            block4: {
                dt = target.durationFrom(this.eventDateList.get(this.currentIndex).getDate());
                if (!(dt < 0.0) || this.currentIndex <= 0) break block4;
                boolean found = false;
                while (this.currentIndex > 0 && !found) {
                    if (target.durationFrom(this.eventDateList.get(this.currentIndex - 1).getDate()) < this.eventDateList.get(this.currentIndex).getDate().durationFrom(target)) {
                        --this.currentIndex;
                        continue;
                    }
                    found = true;
                }
                break block5;
            }
            if (!(dt > 0.0) || this.currentIndex >= this.eventDateList.size() - 1) break block5;
            int maxIndex = this.eventDateList.size() - 1;
            boolean found = false;
            while (this.currentIndex < maxIndex && !found) {
                if (target.durationFrom(this.eventDateList.get(this.currentIndex + 1).getDate()) > this.eventDateList.get(this.currentIndex).getDate().durationFrom(target)) {
                    ++this.currentIndex;
                    continue;
                }
                found = true;
            }
        }
        return this.eventDateList.get(this.currentIndex);
    }

    private static class EventDate
    implements TimeStamped {
        private final AbsoluteDate eventDate;
        private final boolean gIncrease;

        EventDate(AbsoluteDate date, boolean increase) {
            this.eventDate = date;
            this.gIncrease = increase;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.eventDate;
        }

        public boolean isgIncrease() {
            return this.gIncrease;
        }
    }
}

