/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.utils.PVCoordinatesProvider;

public class CylindricalShadowEclipseDetector
extends AbstractDetector<CylindricalShadowEclipseDetector> {
    private final PVCoordinatesProvider sun;
    private final double occultingBodyRadius;

    public CylindricalShadowEclipseDetector(PVCoordinatesProvider sun, double occultingBodyRadius, EventDetectionSettings eventDetectionSettings, EventHandler handler) {
        super(eventDetectionSettings, handler);
        this.sun = sun;
        this.occultingBodyRadius = FastMath.abs((double)occultingBodyRadius);
    }

    @Deprecated
    public CylindricalShadowEclipseDetector(PVCoordinatesProvider sun, double occultingBodyRadius, AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler) {
        this(sun, occultingBodyRadius, new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
    }

    public CylindricalShadowEclipseDetector(PVCoordinatesProvider sun, double occultingBodyRadius, EventHandler handler) {
        this(sun, occultingBodyRadius, EventDetectionSettings.getDefaultEventDetectionSettings(), handler);
    }

    public double getOccultingBodyRadius() {
        return this.occultingBodyRadius;
    }

    @Override
    public double g(SpacecraftState s) {
        Vector3D sunDirection = (Vector3D)this.sun.getPosition(s.getDate(), s.getFrame()).normalize();
        Vector3D position = s.getPosition();
        double dotProduct = position.dotProduct((Vector)sunDirection);
        if (dotProduct >= 0.0) {
            return position.getNorm() / this.occultingBodyRadius;
        }
        double distanceToCylinderAxis = position.subtract((Vector)sunDirection.scalarMultiply(dotProduct)).getNorm();
        return distanceToCylinderAxis / this.occultingBodyRadius - 1.0;
    }

    @Override
    protected CylindricalShadowEclipseDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new CylindricalShadowEclipseDetector(this.sun, this.occultingBodyRadius, new EventDetectionSettings(newMaxCheck, newThreshold, newMaxIter), newHandler);
    }
}

