/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hipparchus.util.FastMath;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.NegateDetector;
import org.orekit.propagation.events.handlers.ContinueOnEvent;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;

public class BooleanDetector
extends AbstractDetector<BooleanDetector> {
    private final List<EventDetector> detectors;
    private final Operator operator;

    protected BooleanDetector(List<EventDetector> detectors, Operator operator, AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        super(new EventDetectionSettings(newMaxCheck, newThreshold, newMaxIter), newHandler);
        this.detectors = detectors;
        this.operator = operator;
    }

    public static BooleanDetector andCombine(EventDetector ... detectors) {
        return BooleanDetector.andCombine(Arrays.asList(detectors));
    }

    public static BooleanDetector andCombine(Collection<? extends EventDetector> detectors) {
        return new BooleanDetector(new ArrayList<EventDetector>(detectors), Operator.AND, s -> {
            double minInterval = Double.POSITIVE_INFINITY;
            for (EventDetector detector : detectors) {
                minInterval = FastMath.min((double)minInterval, (double)detector.getMaxCheckInterval().currentInterval(s));
            }
            return minInterval;
        }, detectors.stream().map(EventDetector::getThreshold).min(Double::compareTo).get(), detectors.stream().map(EventDetector::getMaxIterationCount).min(Integer::compareTo).get(), new ContinueOnEvent());
    }

    public static BooleanDetector orCombine(EventDetector ... detectors) {
        return BooleanDetector.orCombine(Arrays.asList(detectors));
    }

    public static BooleanDetector orCombine(Collection<? extends EventDetector> detectors) {
        return new BooleanDetector(new ArrayList<EventDetector>(detectors), Operator.OR, s -> {
            double minInterval = Double.POSITIVE_INFINITY;
            for (EventDetector detector : detectors) {
                minInterval = FastMath.min((double)minInterval, (double)detector.getMaxCheckInterval().currentInterval(s));
            }
            return minInterval;
        }, detectors.stream().map(EventDetector::getThreshold).min(Double::compareTo).get(), detectors.stream().map(EventDetector::getMaxIterationCount).min(Integer::compareTo).get(), new ContinueOnEvent());
    }

    public static NegateDetector notCombine(EventDetector detector) {
        return new NegateDetector(detector);
    }

    @Override
    public double g(SpacecraftState s) {
        double ret = Double.NaN;
        boolean first = true;
        for (EventDetector detector : this.detectors) {
            if (first) {
                ret = detector.g(s);
                first = false;
                continue;
            }
            ret = this.operator.combine(ret, detector.g(s));
        }
        return ret;
    }

    @Override
    protected BooleanDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new BooleanDetector(this.detectors, this.operator, newMaxCheck, newThreshold, newMaxIter, newHandler);
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        super.init(s0, t);
        for (EventDetector detector : this.detectors) {
            detector.init(s0, t);
        }
    }

    public List<EventDetector> getDetectors() {
        return new ArrayList<EventDetector>(this.detectors);
    }

    private static enum Operator {
        AND{

            @Override
            public double combine(double g1, double g2) {
                return FastMath.min((double)g1, (double)g2);
            }
        }
        ,
        OR{

            @Override
            public double combine(double g1, double g2) {
                return FastMath.max((double)g1, (double)g2);
            }
        };


        public abstract double combine(double var1, double var3);
    }
}

