/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.CelestialBodyFactory;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnEvent;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public class BetaAngleDetector
extends AbstractDetector<BetaAngleDetector> {
    private final double betaAngleThreshold;
    private final PVCoordinatesProvider celestialBodyProvider;
    private final Frame inertialFrame;

    @DefaultDataContext
    public BetaAngleDetector(double betaAngleThreshold) {
        this(betaAngleThreshold, CelestialBodyFactory.getSun(), FramesFactory.getGCRF());
    }

    public BetaAngleDetector(double betaAngleThreshold, PVCoordinatesProvider celestialBodyProvider, Frame inertialFrame) {
        this(AdaptableInterval.of(600.0), 1.0E-6, 100, new StopOnEvent(), betaAngleThreshold, celestialBodyProvider, inertialFrame);
    }

    protected BetaAngleDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, double betaAngleThreshold, PVCoordinatesProvider celestialBodyProvider, Frame inertialFrame) {
        super(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
        this.betaAngleThreshold = betaAngleThreshold;
        this.celestialBodyProvider = celestialBodyProvider;
        this.inertialFrame = inertialFrame;
    }

    public PVCoordinatesProvider getCelestialBodyProvider() {
        return this.celestialBodyProvider;
    }

    public Frame getInertialFrame() {
        return this.inertialFrame;
    }

    public double getBetaAngleThreshold() {
        return this.betaAngleThreshold;
    }

    public BetaAngleDetector withCelestialProvider(PVCoordinatesProvider newProvider) {
        return new BetaAngleDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), this.getBetaAngleThreshold(), newProvider, this.getInertialFrame());
    }

    public BetaAngleDetector withBetaThreshold(double newBetaAngleThreshold) {
        return new BetaAngleDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), newBetaAngleThreshold, this.getCelestialBodyProvider(), this.getInertialFrame());
    }

    public BetaAngleDetector withInertialFrame(Frame newFrame) {
        return new BetaAngleDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), this.getBetaAngleThreshold(), this.getCelestialBodyProvider(), newFrame);
    }

    @Override
    public double g(SpacecraftState s) {
        double beta = BetaAngleDetector.calculateBetaAngle(s, this.celestialBodyProvider, this.inertialFrame);
        return this.betaAngleThreshold - beta;
    }

    public static double calculateBetaAngle(SpacecraftState state, PVCoordinatesProvider celestialBodyProvider) {
        return BetaAngleDetector.calculateBetaAngle(state, celestialBodyProvider, state.getFrame());
    }

    public static double calculateBetaAngle(SpacecraftState state, PVCoordinatesProvider celestialBodyProvider, Frame frame) {
        Vector3D celestialP = celestialBodyProvider.getPosition(state.getDate(), frame);
        TimeStampedPVCoordinates pv = state.getPVCoordinates(frame);
        return 1.5707963267948966 - Vector3D.angle((Vector3D)celestialP, (Vector3D)pv.getMomentum());
    }

    @Override
    protected BetaAngleDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new BetaAngleDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.getBetaAngleThreshold(), this.getCelestialBodyProvider(), this.getInertialFrame());
    }
}

