/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;
import org.orekit.utils.TimeStampedPVCoordinates;

public class ApsideDetector
extends AbstractDetector<ApsideDetector> {
    public ApsideDetector(double keplerianPeriod) {
        super(keplerianPeriod / 3.0, 1.0E-13 * keplerianPeriod, 100, (EventHandler)new StopOnIncreasing());
    }

    public ApsideDetector(Orbit orbit) {
        this(orbit.getKeplerianPeriod());
    }

    public ApsideDetector(double threshold, Orbit orbit) {
        super(orbit.getKeplerianPeriod() / 3.0, threshold, 100, (EventHandler)new StopOnIncreasing());
    }

    public ApsideDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler) {
        super(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
    }

    @Override
    protected ApsideDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new ApsideDetector(newMaxCheck, newThreshold, newMaxIter, newHandler);
    }

    @Override
    public double g(SpacecraftState s) {
        TimeStampedPVCoordinates pv = s.getPVCoordinates();
        return Vector3D.dotProduct((Vector3D)pv.getPosition(), (Vector3D)pv.getVelocity());
    }
}

