/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnDecreasing;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AngularSeparationFromSatelliteDetector
extends AbstractDetector<AngularSeparationFromSatelliteDetector> {
    private final PVCoordinatesProvider primaryObject;
    private final PVCoordinatesProvider secondaryObject;
    private final double proximityAngle;

    public AngularSeparationFromSatelliteDetector(PVCoordinatesProvider primaryObject, PVCoordinatesProvider secondaryObject, double proximityAngle) {
        this(AdaptableInterval.of(600.0), 1.0E-6, 100, new StopOnDecreasing(), primaryObject, secondaryObject, proximityAngle);
    }

    protected AngularSeparationFromSatelliteDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, PVCoordinatesProvider primaryObject, PVCoordinatesProvider secondaryObject, double proximityAngle) {
        super(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
        this.primaryObject = primaryObject;
        this.secondaryObject = secondaryObject;
        this.proximityAngle = proximityAngle;
    }

    @Override
    protected AngularSeparationFromSatelliteDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new AngularSeparationFromSatelliteDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.primaryObject, this.secondaryObject, this.proximityAngle);
    }

    public PVCoordinatesProvider getPrimaryObject() {
        return this.primaryObject;
    }

    public PVCoordinatesProvider getSecondaryObject() {
        return this.secondaryObject;
    }

    public double getProximityAngle() {
        return this.proximityAngle;
    }

    @Override
    public double g(SpacecraftState s) {
        TimeStampedPVCoordinates sPV = s.getPVCoordinates();
        Vector3D primaryPos = this.primaryObject.getPosition(s.getDate(), s.getFrame());
        Vector3D secondaryPos = this.secondaryObject.getPosition(s.getDate(), s.getFrame());
        double separation = Vector3D.angle((Vector3D)primaryPos.subtract((Vector)sPV.getPosition()), (Vector3D)secondaryPos.subtract((Vector)sPV.getPosition()));
        return separation - this.proximityAngle;
    }
}

