/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnDecreasing;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AngularSeparationDetector
extends AbstractDetector<AngularSeparationDetector> {
    private final PVCoordinatesProvider beacon;
    private final PVCoordinatesProvider observer;
    private final double proximityAngle;

    public AngularSeparationDetector(PVCoordinatesProvider beacon, PVCoordinatesProvider observer, double proximityAngle) {
        this(AdaptableInterval.of(60.0), 0.001, 100, new StopOnDecreasing(), beacon, observer, proximityAngle);
    }

    protected AngularSeparationDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, PVCoordinatesProvider beacon, PVCoordinatesProvider observer, double proximityAngle) {
        super(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
        this.beacon = beacon;
        this.observer = observer;
        this.proximityAngle = proximityAngle;
    }

    @Override
    protected AngularSeparationDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new AngularSeparationDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.beacon, this.observer, this.proximityAngle);
    }

    public PVCoordinatesProvider getBeacon() {
        return this.beacon;
    }

    public PVCoordinatesProvider getObserver() {
        return this.observer;
    }

    public double getProximityAngle() {
        return this.proximityAngle;
    }

    @Override
    public double g(SpacecraftState s) {
        TimeStampedPVCoordinates sPV = s.getPVCoordinates();
        Vector3D bP = this.beacon.getPosition(s.getDate(), s.getFrame());
        Vector3D oP = this.observer.getPosition(s.getDate(), s.getFrame());
        double separation = Vector3D.angle((Vector3D)sPV.getPosition().subtract((Vector)oP), (Vector3D)bP.subtract((Vector)oP));
        return separation - this.proximityAngle;
    }
}

