/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.orekit.bodies.BodyShape;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnDecreasing;

public class AltitudeDetector
extends AbstractDetector<AltitudeDetector> {
    private final double altitude;
    private final BodyShape bodyShape;

    public AltitudeDetector(double altitude, BodyShape bodyShape) {
        this(600.0, 1.0E-6, altitude, bodyShape);
    }

    public AltitudeDetector(double maxCheck, double altitude, BodyShape bodyShape) {
        this(maxCheck, 1.0E-6, altitude, bodyShape);
    }

    public AltitudeDetector(double maxCheck, double threshold, double altitude, BodyShape bodyShape) {
        this(AdaptableInterval.of(maxCheck), threshold, 100, new StopOnDecreasing(), altitude, bodyShape);
    }

    protected AltitudeDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, double altitude, BodyShape bodyShape) {
        super(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
        this.altitude = altitude;
        this.bodyShape = bodyShape;
    }

    @Override
    protected AltitudeDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new AltitudeDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.altitude, this.bodyShape);
    }

    public double getAltitude() {
        return this.altitude;
    }

    public BodyShape getBodyShape() {
        return this.bodyShape;
    }

    @Override
    public double g(SpacecraftState s) {
        Frame bodyFrame = this.bodyShape.getBodyFrame();
        GeodeticPoint point = this.bodyShape.transform(s.getPosition(bodyFrame), bodyFrame, s.getDate());
        return point.getAltitude() - this.altitude;
    }
}

