/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;

public abstract class AbstractDetector<T extends AbstractDetector<T>>
implements EventDetector {
    public static final double DEFAULT_MAXCHECK = 600.0;
    public static final double DEFAULT_THRESHOLD = 1.0E-6;
    public static final int DEFAULT_MAX_ITER = 100;
    private final EventDetectionSettings eventDetectionSettings;
    private final EventHandler handler;
    private boolean forward;

    protected AbstractDetector(double maxCheck, double threshold, int maxIter, EventHandler handler) {
        this(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
    }

    @Deprecated
    protected AbstractDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler) {
        this(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
    }

    protected AbstractDetector(EventDetectionSettings detectionSettings, EventHandler handler) {
        this.checkStrictlyPositive(detectionSettings.getThreshold());
        this.eventDetectionSettings = detectionSettings;
        this.handler = handler;
        this.forward = true;
    }

    private void checkStrictlyPositive(double value) throws OrekitException {
        if (value <= 0.0) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_STRICTLY_POSITIVE, value);
        }
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        this.forward = t.durationFrom(s0.getDate()) >= 0.0;
        this.getHandler().init(s0, t, this);
    }

    @Override
    public EventDetectionSettings getDetectionSettings() {
        return this.eventDetectionSettings;
    }

    @Override
    public AdaptableInterval getMaxCheckInterval() {
        return this.getDetectionSettings().getMaxCheckInterval();
    }

    @Override
    public int getMaxIterationCount() {
        return this.getDetectionSettings().getMaxIterationCount();
    }

    @Override
    public double getThreshold() {
        return this.getDetectionSettings().getThreshold();
    }

    public T withMaxCheck(double newMaxCheck) {
        return this.withMaxCheck(AdaptableInterval.of(newMaxCheck));
    }

    public T withMaxCheck(AdaptableInterval newMaxCheck) {
        return this.create(new EventDetectionSettings(newMaxCheck, this.getThreshold(), this.getMaxIterationCount()), this.getHandler());
    }

    public T withMaxIter(int newMaxIter) {
        return this.create(new EventDetectionSettings(this.getMaxCheckInterval(), this.getThreshold(), newMaxIter), this.getHandler());
    }

    public T withThreshold(double newThreshold) {
        return this.create(new EventDetectionSettings(this.getMaxCheckInterval(), newThreshold, this.getMaxIterationCount()), this.getHandler());
    }

    public T withDetectionSettings(EventDetectionSettings newSettings) {
        return this.create(new EventDetectionSettings(newSettings.getMaxCheckInterval(), newSettings.getThreshold(), newSettings.getMaxIterationCount()), this.getHandler());
    }

    public T withHandler(EventHandler newHandler) {
        return this.create(this.getDetectionSettings(), newHandler);
    }

    @Override
    public EventHandler getHandler() {
        return this.handler;
    }

    protected abstract T create(AdaptableInterval var1, double var2, int var4, EventHandler var5);

    protected T create(EventDetectionSettings detectionSettings, EventHandler newHandler) {
        return this.create(detectionSettings.getMaxCheckInterval(), detectionSettings.getThreshold(), detectionSettings.getMaxIterationCount(), newHandler);
    }

    public boolean isForward() {
        return this.forward;
    }
}

