/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion.averaging.converters;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.propagation.analytical.tle.generation.FixedPointTleGenerationAlgorithm;
import org.orekit.propagation.conversion.averaging.SGP4OrbitalState;
import org.orekit.propagation.conversion.averaging.converters.FixedPointOsculatingToAveragedConverter;
import org.orekit.time.UTCScale;

public class OsculatingToSGP4Converter
extends FixedPointOsculatingToAveragedConverter<SGP4OrbitalState> {
    private static final String TEMPLATE_LINE_1 = "1 27421U 02021A   02124.48976499 -.00021470  00000-0 -89879-2 0    20";
    private static final String TEMPLATE_LINE_2 = "2 27421  98.7490 199.5121 0001333 133.9522 226.1918 14.26113993    62";
    private final double scale;
    private final UTCScale utc;
    private final Frame teme;

    @DefaultDataContext
    public OsculatingToSGP4Converter() {
        this(DataContext.getDefault());
    }

    public OsculatingToSGP4Converter(DataContext dataContext) {
        this(1.0E-12, 100, 1.0, dataContext);
    }

    public OsculatingToSGP4Converter(double epsilon, int maxIterations, double scale, DataContext dataContext) {
        super(epsilon, maxIterations);
        this.scale = scale;
        this.utc = dataContext.getTimeScales().getUTC();
        this.teme = dataContext.getFrames().getTEME();
    }

    @Override
    public SGP4OrbitalState convertToAveraged(Orbit osculatingOrbit) {
        FixedPointTleGenerationAlgorithm fixedPointAlgorithm = new FixedPointTleGenerationAlgorithm(this.getEpsilon(), this.getMaxIterations(), this.scale, this.utc, this.teme);
        SpacecraftState osculatingState = new SpacecraftState(osculatingOrbit);
        TLE templateTLe = new TLE(TEMPLATE_LINE_1, TEMPLATE_LINE_2, this.utc);
        TLE tle = fixedPointAlgorithm.generate(osculatingState, templateTLe);
        return SGP4OrbitalState.of(tle, this.teme);
    }
}

