/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion.averaging.converters;

import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.orbits.CircularOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.analytical.EcksteinHechlerPropagator;
import org.orekit.propagation.conversion.averaging.EcksteinHechlerOrbitalState;
import org.orekit.propagation.conversion.averaging.converters.FixedPointOsculatingToAveragedConverter;
import org.orekit.propagation.conversion.averaging.elements.AveragedCircularWithMeanAngle;

public class OsculatingToEcksteinHechlerConverter
extends FixedPointOsculatingToAveragedConverter<EcksteinHechlerOrbitalState> {
    private static final int HARMONICS_ORDER = 0;
    private final UnnormalizedSphericalHarmonicsProvider harmonicsProvider;

    public OsculatingToEcksteinHechlerConverter(UnnormalizedSphericalHarmonicsProvider harmonicsProvider) {
        this(1.0E-12, 100, harmonicsProvider);
    }

    public OsculatingToEcksteinHechlerConverter(double epsilon, int maxIterations, UnnormalizedSphericalHarmonicsProvider harmonicsProvider) {
        super(epsilon, maxIterations);
        this.harmonicsProvider = harmonicsProvider;
    }

    @Override
    public EcksteinHechlerOrbitalState convertToAveraged(Orbit osculatingOrbit) {
        CircularOrbit averagedOrbit = this.createAveragedOrbit(osculatingOrbit);
        AveragedCircularWithMeanAngle elements = this.buildElements(averagedOrbit);
        return new EcksteinHechlerOrbitalState(averagedOrbit.getDate(), elements, averagedOrbit.getFrame(), this.harmonicsProvider);
    }

    private CircularOrbit createAveragedOrbit(Orbit osculatingOrbit) {
        UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics = this.harmonicsProvider.onDate(osculatingOrbit.getDate());
        return EcksteinHechlerPropagator.computeMeanOrbit(osculatingOrbit, this.harmonicsProvider.getAe(), this.harmonicsProvider.getMu(), harmonics.getUnnormalizedCnm(2, 0), harmonics.getUnnormalizedCnm(3, 0), harmonics.getUnnormalizedCnm(4, 0), harmonics.getUnnormalizedCnm(5, 0), harmonics.getUnnormalizedCnm(6, 0), this.getEpsilon(), this.getMaxIterations());
    }

    private AveragedCircularWithMeanAngle buildElements(CircularOrbit averagedOrbit) {
        return new AveragedCircularWithMeanAngle(averagedOrbit.getA(), averagedOrbit.getCircularEx(), averagedOrbit.getCircularEy(), averagedOrbit.getI(), averagedOrbit.getRightAscensionOfAscendingNode(), averagedOrbit.getAlphaM());
    }
}

