/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion.averaging.converters;

import java.util.Collection;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.averaging.DSST6X0OrbitalState;
import org.orekit.propagation.conversion.averaging.converters.FixedPointOsculatingToAveragedConverter;
import org.orekit.propagation.conversion.averaging.elements.AveragedEquinoctialWithMeanAngle;
import org.orekit.propagation.semianalytical.dsst.DSSTPropagator;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;

public class OsculatingToDSST6X0Converter
extends FixedPointOsculatingToAveragedConverter<DSST6X0OrbitalState> {
    private final UnnormalizedSphericalHarmonicsProvider harmonicsProvider;

    public OsculatingToDSST6X0Converter(UnnormalizedSphericalHarmonicsProvider harmonicsProvider) {
        this(1.0E-12, 100, harmonicsProvider);
    }

    public OsculatingToDSST6X0Converter(double epsilon, int maxIterations, UnnormalizedSphericalHarmonicsProvider harmonicsProvider) {
        super(epsilon, maxIterations);
        this.harmonicsProvider = harmonicsProvider;
    }

    @Override
    public DSST6X0OrbitalState convertToAveraged(Orbit osculatingOrbit) {
        Orbit averagedOrbit = this.createAveragedOrbit(osculatingOrbit);
        AveragedEquinoctialWithMeanAngle elements = this.buildElements(averagedOrbit);
        return new DSST6X0OrbitalState(averagedOrbit.getDate(), elements, averagedOrbit.getFrame(), this.harmonicsProvider);
    }

    private Orbit createAveragedOrbit(Orbit osculatingOrbit) {
        Collection<DSSTForceModel> forceModels = DSST6X0OrbitalState.createForces(this.harmonicsProvider);
        SpacecraftState osculatingState = new SpacecraftState(osculatingOrbit);
        SpacecraftState averagedState = DSSTPropagator.computeMeanState(osculatingState, null, forceModels, this.getEpsilon(), this.getMaxIterations());
        return averagedState.getOrbit();
    }

    private AveragedEquinoctialWithMeanAngle buildElements(Orbit averagedOrbit) {
        return new AveragedEquinoctialWithMeanAngle(averagedOrbit.getA(), averagedOrbit.getEquinoctialEx(), averagedOrbit.getEquinoctialEy(), averagedOrbit.getHx(), averagedOrbit.getHy(), averagedOrbit.getLM());
    }
}

