/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion.averaging.converters;

import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.analytical.BrouwerLyddanePropagator;
import org.orekit.propagation.conversion.averaging.BrouwerLyddaneOrbitalState;
import org.orekit.propagation.conversion.averaging.converters.FixedPointOsculatingToAveragedConverter;
import org.orekit.propagation.conversion.averaging.elements.AveragedKeplerianWithMeanAngle;

public class OsculatingToBrouwerLyddaneConverter
extends FixedPointOsculatingToAveragedConverter<BrouwerLyddaneOrbitalState> {
    private static final double M2 = 0.0;
    private static final int HARMONICS_ORDER = 0;
    private final UnnormalizedSphericalHarmonicsProvider harmonicsProvider;

    public OsculatingToBrouwerLyddaneConverter(UnnormalizedSphericalHarmonicsProvider harmonicsProvider) {
        this(1.0E-12, 100, harmonicsProvider);
    }

    public OsculatingToBrouwerLyddaneConverter(double epsilon, int maxIterations, UnnormalizedSphericalHarmonicsProvider harmonicsProvider) {
        super(epsilon, maxIterations);
        this.harmonicsProvider = harmonicsProvider;
    }

    @Override
    public BrouwerLyddaneOrbitalState convertToAveraged(Orbit osculatingOrbit) {
        KeplerianOrbit averagedOrbit = this.createAveragedOrbit(osculatingOrbit);
        AveragedKeplerianWithMeanAngle averagedElements = this.buildElements(averagedOrbit);
        return new BrouwerLyddaneOrbitalState(averagedOrbit.getDate(), averagedElements, averagedOrbit.getFrame(), this.harmonicsProvider);
    }

    private KeplerianOrbit createAveragedOrbit(Orbit osculatingOrbit) {
        UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics = this.harmonicsProvider.onDate(osculatingOrbit.getDate());
        return BrouwerLyddanePropagator.computeMeanOrbit(osculatingOrbit, this.harmonicsProvider.getAe(), this.harmonicsProvider.getMu(), harmonics.getUnnormalizedCnm(2, 0), harmonics.getUnnormalizedCnm(3, 0), harmonics.getUnnormalizedCnm(4, 0), harmonics.getUnnormalizedCnm(5, 0), 0.0, this.getEpsilon(), this.getMaxIterations());
    }

    private AveragedKeplerianWithMeanAngle buildElements(KeplerianOrbit averagedOrbit) {
        return new AveragedKeplerianWithMeanAngle(averagedOrbit.getA(), averagedOrbit.getE(), averagedOrbit.getI(), averagedOrbit.getPerigeeArgument(), averagedOrbit.getRightAscensionOfAscendingNode(), averagedOrbit.getMeanAnomaly());
    }
}

