/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion.averaging;

import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.propagation.conversion.averaging.AbstractAveragedOrbitalState;
import org.orekit.propagation.conversion.averaging.elements.AveragedKeplerianWithMeanAngle;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.UTCScale;

public class SGP4OrbitalState
extends AbstractAveragedOrbitalState {
    private static final double B_STAR = 0.0;
    private final AveragedKeplerianWithMeanAngle averagedElements;
    private final UTCScale utc;

    public SGP4OrbitalState(AbsoluteDate date, AveragedKeplerianWithMeanAngle elements, DataContext dataContext) {
        this(date, elements, dataContext.getFrames().getTEME(), dataContext.getTimeScales().getUTC());
    }

    @DefaultDataContext
    public SGP4OrbitalState(AbsoluteDate date, AveragedKeplerianWithMeanAngle elements) {
        this(date, elements, DataContext.getDefault());
    }

    private SGP4OrbitalState(AbsoluteDate date, AveragedKeplerianWithMeanAngle elements, Frame teme, TimeScale utc) {
        super(date, teme);
        this.averagedElements = elements;
        this.utc = (UTCScale)utc;
    }

    public static SGP4OrbitalState of(TLE tle, Frame teme) {
        double semiMajorAxis = SGP4OrbitalState.computeSemiMajorAxis(tle);
        AveragedKeplerianWithMeanAngle elements = new AveragedKeplerianWithMeanAngle(semiMajorAxis, tle.getE(), tle.getI(), tle.getPerigeeArgument(), tle.getRaan(), tle.getMeanAnomaly());
        return new SGP4OrbitalState(tle.getDate(), elements, teme, tle.getUtc());
    }

    @Override
    public double getMu() {
        return SGP4OrbitalState.getTleMu();
    }

    private static double getTleMu() {
        return TLEPropagator.getMU();
    }

    @Override
    public OrbitType getOrbitType() {
        return OrbitType.KEPLERIAN;
    }

    @Override
    public PositionAngleType getPositionAngleType() {
        return PositionAngleType.MEAN;
    }

    @Override
    public AveragedKeplerianWithMeanAngle getAveragedElements() {
        return this.averagedElements;
    }

    @Override
    public Orbit toOsculatingOrbit() {
        TLEPropagator propagator = this.createPropagator();
        return propagator.getInitialState().getOrbit();
    }

    private TLEPropagator createPropagator() {
        TLE tle = this.createTLE();
        return TLEPropagator.selectExtrapolator(tle, this.getFrame());
    }

    private TLE createTLE() {
        double averagedMeanMotion = SGP4OrbitalState.computeMeanMotion(this.getAveragedElements().getAveragedSemiMajorAxis());
        double averagedEccentricity = this.getAveragedElements().getAveragedEccentricity();
        double averagedInclination = this.getAveragedElements().getAveragedInclination();
        double averagedRAAN = this.getAveragedElements().getAveragedRightAscensionOfTheAscendingNode();
        double averagedPerigeeArgument = this.getAveragedElements().getAveragedPerigeeArgument();
        double averagedMeanAnomaly = this.getAveragedElements().getAveragedMeanAnomaly();
        return new TLE(0, '\u0000', 2000, 1, "1", 0, 0, this.getDate(), averagedMeanMotion, 0.0, 0.0, averagedEccentricity, averagedInclination, averagedPerigeeArgument, averagedRAAN, averagedMeanAnomaly, 1, 0.0, this.utc);
    }

    private static double computeMeanMotion(double averagedSemiMajorAxis) {
        double cubedSemiMajorAxis = averagedSemiMajorAxis * averagedSemiMajorAxis * averagedSemiMajorAxis;
        return FastMath.sqrt((double)(SGP4OrbitalState.getTleMu() / cubedSemiMajorAxis));
    }

    private static double computeSemiMajorAxis(TLE tle) {
        double meanMotion = tle.getMeanMotion();
        return FastMath.cbrt((double)(SGP4OrbitalState.getTleMu() / (meanMotion * meanMotion)));
    }
}

